'''
Defines L{Tools} that function as a set of utilities.

@author: Brett Clippingdale
@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

import Base, LSRConstants

class Utils(Base.TaskTools):
  '''
  Provides utility methods that assist L{Perk} developers in processing 
  accessibility information, but do not touch accessible objects, do output,
  handle input, manage the LSR system, etc.
  '''
  def getColorString(self, val):
    '''
    Tries to map a given RGB string (if in form "u,u,u") to a nearby color name
    
    @param val: representation of an RGB color in form "u,u,u"
    @type val: string
    @return: color name if val param is valid format, val otherwise
    @rtype: string, or val type if val returned
    '''
    # if color value an RGB 3-tuple, map it to a string value
    try:
      r, g, b = val.split(",")
      r, g, b = int(r), int(g), int(b)
    except (ValueError, TypeError):
      return val
    WORD = 256 # 8-bit word size
    # @todo: DBC: tweak these values
    VISIBLE = 64
    LOW_COLORATION = 4 
    LOW_SATURATION = 192
    HIGH_SATURATION = 240
    
    # normalize values into three 8-bit values to reprent RGB color
    if r >= WORD or g >= WORD or b >= WORD:
      r = int(r / WORD) # can't guarantee apps will have modulo 256 color
      g = int(g / WORD)
      b = int(b / WORD)
    
    # if all values of RGB 3-tuple have low saturation, amplify them
    while r < VISIBLE and g < VISIBLE and b < VISIBLE and \
          (r > LOW_COLORATION or g > LOW_COLORATION or b > LOW_COLORATION):
      print "low saturation: shifting rgb from:", r, g, b
      r = r << 1
      g = g << 1
      b = b << 1
      print "shifted rgb to:" , r, g, b
      
    # attenuation algo #1  
    ## if all values of RGB 3-tuple have high saturation, attenuate them
    #while r >= LOW_SATURATION and g >= LOW_SATURATION and b >= LOW_SATURATION and \
          #(r < HIGH_SATURATION or g < HIGH_SATURATION or b < HIGH_SATURATION):
      #print "high saturation: shifting rgb from:", r, g, b
      #r = r >> 1
      #g = g >> 1
      #b = b >> 1
      #print "shifted rgb to:" , r, g, b
    
    # attenuation algo #2
    # if all values of RGB 3-tuple have high saturation, attenuate them
    if r >= LOW_SATURATION and g >= LOW_SATURATION and b >= LOW_SATURATION and \
       (r < HIGH_SATURATION or g < HIGH_SATURATION or b < HIGH_SATURATION):
      print "high saturation: shifting rgb from:", r, g, b
      if r < g and r < b:
        r = r - 64
      elif g < r and g < b:
        g = g - 64
      elif b < r and b < g:
        b = b - 64
      elif r == g == b:
        # assign levels of grey based on saturation
        if r > 250:
          return LSRConstants.COLOR_MAP[63] #'white'
        elif r > 200:
          return LSRConstants.COLOR_MAP[41] # light grey
        elif r > 96:
          return LSRConstants.COLOR_MAP[21] # medium grey
        else:
          return LSRConstants.COLOR_MAP[42] # dark grey
        pass
      elif r == g:
        r = r - 64
        g = g - 64
      elif r == b:
        r = r - 64
        b = b - 64
      elif g == b:
        g = g - 64
        b = b - 64
      print "shifted rgb to:" , r, g, b
      
    # place high 2-bits of each color into bitfield: rrggbb for value 0..63
    r = r >> 6 << 4
    g = g >> 6 << 2
    b = b >> 6
    rgb = r+g+b # add into 6-bit bitfield (rrggbb) for integer value 0..63
    name = LSRConstants.COLOR_MAP[rgb] # get the color value from dictionary
    return name
  
 