'''
Defines a function that allows L{Task} classes to register their names to 
suggest all possible event names and defaults to buffer to an 
L{AEMonitor}s.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''
from AEEvent import LAYER_FOCUS, LAYER_TIER, LAYER_BACKGROUND

# recommendation for which tasks should be displayed by default by EventMonitor
_default_types = []
# all registered Task types; used to build display menu in EventMonitor
_all_types = []

def registerTaskType(name, default):
  '''
  Called once by every L{Task} class to register itself for buffering and 
  filtering by an L{AEMonitor}.
  
  @param name: Name of the L{Task}
  @type name: string
  @param default: Should this L{Task} be buffered by default?
  @type default: boolean
  '''
  global _default_types
  global _all_types
  _all_types.append(name)
  if default:
    _default_types.append(name)