'''
Defines constants used by the L{AEOutput} package.

@todo: PP: document commands

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''
# common commands for serial output devices (e.g. audio, Braille)
CMD_STOP = 0
CMD_TALK = 1
CMD_STRING = 2
CMD_STRING_SYNC = 3
CMD_FILENAME = 4

# commands for Braille devices
CMD_CARET = 5
CMD_TRUNCATE = 7

# commands for audio devices
CMD_INDEX = 6

# commands for magnifiers

# provide a reverse mapping from command constants to string command names
COMMAND_NAMES = dict([(value, name.lower()[4:].replace('_', ' '))
                      for name, value in 
                      locals().items() if name.startswith('CMD_')])

# expose command names for IO monitors
all_types = COMMAND_NAMES.values()
default_types = [COMMAND_NAMES[i] for i in (CMD_STOP, CMD_TALK, CMD_STRING,
                                           CMD_FILENAME)]