'''
Defines a L{Perk} for the gnome-terminal to correct caret event handling.

@todo: PP: only announces caret movement at present; extend to support all 
  caret events

@author: Peter Parente, Brett Clippingdale
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''
import Task, Perk
from POR import POR

__uie__ = dict(kind='perk', tier='gnome-terminal')

class GTerminalPerk(Perk.Perk):
  '''
  Corrects basic accessibility problems in gnome-terminal. Supplements the 
  DefaultPerk.
  '''
  def init(self):
    '''
    Registers a L{HandleCaretChange} task. Initializes an instance variable to
    store the previous caret L{POR}.
    '''
    # set an audio device as the default output
    self.setPerkIdealOutput('audio')    
    self.registerTask(HandleCaretChange())

class GTerminalPerk(Perk.Perk):
  '''
  Corrects basic accessibility problems in gnome-terminal. Supplements the 
  DefaultPerk.
  
  @ivar last_caret: Stores the previous caret L{POR}
  @type last_caret: L{POR}
  '''
  def init(self):
    '''
    Registers a L{HandleCaretChange} task. Initializes an instance variable to
    store the previous caret L{POR}.
    '''
    self.registerTask(HandleCaretChange(self))
    self.last_caret = POR()
    
class HandleCaretChange(Task.CaretTask):
  '''
  Task that handles a L{AEEvent.CaretChange} in the terminal window itself.
  '''  
  def executeInserted(self, por, text, text_offset, **kwargs):
    '''
    Blocks the execution of any insert handling tasks within the terminal.
    '''
    if self.hasAccRole('terminal', por):
      #print "GTerminalPerk::HandleCaretChange::executeInserted()"
      #print "inserted text: " , len(text) , text 
      if len(text) > 1:
        self.stopNow()
        #self.inhibitMayStop()
        self.say(text)
      return False
  
  def executeDeleted(self, por, text, text_offset, **kwargs):
    '''
    Blocks the execution of any delete handling tasks within the terminal.
    '''
    if self.hasAccRole('terminal', por):
      return False