'''
Defines a L{Task} to execute when a setting value changes.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''

import EventTask, Constants
import AEEvent

class SettingTask(EventTask.EventTask):
  '''
  Executed when a setting change occurs. 

  This class registers its name and whether it should be monitored by default in
  an L{AEMonitor} using the L{Constants.registerTaskType} function
  when this module is first imported. The L{AEMonitor} can use this
  information to build its menus.
  '''
  Constants.registerTaskType('SettingTask', False)

  def getEventType(self):
    '''
    @return: Type of L{AEEvent} this L{Task} wants to handle
    @rtype: class
    '''
    return AEEvent.SettingChange
  
  def update(self, source, state, name, value, layer, **kwargs):
    '''
    Updates this L{Task} in response to a consumed setting change event. Called
    by L{Tier.Tier._executeTask}.
    
    @param source: Object that caused the setting change
    @type source: L{UIElement}
    @param state: State object having the setting that changed
    @type state: L{AEState}
    @param name: Name of the setting that changed
    @type name: string
    @param value: New value of the setting
    @type value: object
    '''
    pass
  
  def execute(self, source, state, name, value, **kwargs):
    '''
    Executes this L{Task} in response to a setting change event. Called by 
    L{Tier.Tier._executeTask}.
    
    @param source: Object that caused the setting change
    @type source: L{UIElement}
    param state: State object having the setting that changed
    @type state: L{AEState}
    @param name: Name of the setting that changed
    @type name: string
    @param value: New value of the setting
    @type value: object
    @return: True to allow other L{Task}s to process this event
    @rtype: boolean
    '''
    return True