'''
Platform specific constants.

@var PROG_NAME: Name of this program
@type PROG_NAME: string
@var PROG_VERSION: Version of this program
@type PROG_VERSION: string
@var PROG_DATE: Date of this program's last install or packaging
@type PROG_DATE: string
@var NAME: Human readable name of this program
@type NAME: string
@var COPYRIGHT: Copyright notice for this program
@type COPYRIGHT: string
@var LICENSE: License summary for this program
@type LICENSE: string
@var PREFIX: Install prefix for this program
@type PREFIX: string
@var HOME_USER: Configuration directory for the Unix user currently running
  this program
@type HOME_USER: string
@var HOME_DIR: Home directory for this program install (e.g. 
  /usr/lib/python2.4/site-packages/lsr)
@type HOME_DIR: string
@var DATA_DIR: System data directory for this program install (e.g. 
  /usr/share/lsr)
@type DATA_DIR: string
@var TEMPLATE_DIR: Template data directory for this program install (e.g. 
  /usr/share/lsr/templates)
@type TEMPLATE_DIR: string
@var ICON_SIZES: Sizes for all installed program icons
@type ICON_SIZES: list of integer

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2007 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''
import os

# package name
PROG_NAME = 'lsr'

# version numbers
PROG_VERSION = '0.5.2'
PROG_DATE = 'Mon May 14 22:33:09 UTC 2007'

# name, version, copyright and license notice to print on startup
NAME = 'Linux Screen Reader'
COPYRIGHT = 'Copyright (c) 2005, 2007 IBM Corporation'
LICENSE = 'All rights reserved. This program and the accompanying ' \
        'materials are made available under the terms of the BSD License ' \
        'which accompanies this distribution, and is available at' \
        'http://www.opensource.org/licenses/bsd-license.php'

# home directories and data directories
PREFIX = '/usr/local'
HOME_USER = os.path.join(os.environ['HOME'], '.'+PROG_NAME)
HOME_DIR = os.path.normpath(os.path.join(os.path.dirname(__file__), '..'))
DATA_DIR = os.path.join(PREFIX, 'share', PROG_NAME)
TEMPLATE_DIR = os.path.join(DATA_DIR, 'templates')

# icon sizes
ICON_SIZES = [16, 24, 32, 36, 48, 64, 96]

def initUserPath(pth):
  '''
  Initializes a path in the user's home directory, but only if the uid of the
  current process matches that of the home directory. Use to avoid creating
  paths during install owned by the root user when using sudo.
  
  @param pth: Full path to initialize
  @type pth: string
  @return: Was the path created or not?
  @rtype: boolean
  '''
  try:
    # ensure we're creating in the user's home dir under the same gid
    # uid doesn't work for some special user homes (e.g. gdm) created by
    # the root user
    if os.stat(os.environ['HOME']).st_gid == os.getgid():
      os.makedirs(pth)
      return True
  except OSError:
    pass
  return False
  
# make sure the user home directory is initialized
if initUserPath(HOME_USER):
  print 'created ~/.lsr'
