#
# RPM Package Manager (RPM) spec file for lsr
#
Summary: Linux Screen Reader: Extensible assistive technology
Name: lsr
Version: 0.5.3
Release: %{?custom_release}%{!?custom_release:1}
Prefix: /usr/local
License: BSD
BuildArch: noarch
Group: Desktop/Accessibility
URL: http://live.gnome.org/LSR
Vendor: IBM Corporation
Packager: Peter Parente <pparent@us.ibm.com>
Provides: lsr
Source0: %{name}-%{version}.tar.gz
BuildRoot: %{_builddir}/%{name}-%{version}-rpmroot

BuildRequires: gnome-common >= 2.12.0
Requires: gnome-python2-gconf >= 2.12
Requires: python >= 2.4
Requires: pygtk2 >= 2.8
Requires: pygtk2-libglade >= 2.8
Requires: pyorbit >= 2.14
Requires: at-spi >= 1.7
Requires: gnome-python2 >= 2.12
Requires: glib2 >= 2.10
Requires: gnome-python2-bonobo >= 2.12

%description
Linux Screen Reader (LSR) is an extensible assistive technology for people 
with disabilities. The design philosophy behind LSR is to provide a core 
platform that enables the development of LSR extensions for improving desktop
application accessibility and usability.

%prep
%setup -q

%build
./configure --prefix=%{prefix} --disable-scrollkeeper --without-pyreqs
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%post
$RPM_INSTALL_PREFIX/bin/lsr --init-global

%files
%defattr(-,root,root)
%doc AUTHORS README COPYING NEWS ChangeLog
%{prefix}/man/man1/lsr*
%{prefix}/bin/lsr
%{prefix}/lib/python?.?/site-packages/lsr
%{prefix}/share/locale/*/*/lsr*
%{prefix}/share/lsr/*
%{prefix}/share/icons/hicolor/16x16/apps/lsr.png
%{prefix}/share/icons/hicolor/24x24/apps/lsr.png
%{prefix}/share/icons/hicolor/32x32/apps/lsr.png
%{prefix}/share/icons/hicolor/36x36/apps/lsr.png
%{prefix}/share/icons/hicolor/48x48/apps/lsr.png
%{prefix}/share/icons/hicolor/64x64/apps/lsr.png
%{prefix}/share/icons/hicolor/96x96/apps/lsr.png
%{prefix}/share/pixmaps/lsr.png
%{prefix}/share/applications/lsr.desktop

%changelog
* Mon Apr 24 2007 Peter Parente <parente@cs.unc.edu>
- Switched to manual install of desktop file
* Mon Apr 02 2007 Peter Parente <parente@cs.unc.edu>
- Added --without-pyreqs check at build time
* Wed Jan 10 2007 Peter Parente <parente@cs.unc.edu>
- Added icons to files section
* Tue Jan 02 2007 Peter Parente <parente@cs.unc.edu>
- Changed to support autoconf prefix
