/* mergeant.c
 *
 * Copyright (C) 1999 - 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <gnome.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <bonobo.h>
#include <libgnomeui/gnome-client.h>
#include <libgnomedb/libgnomedb.h>

#include "session.h"
#include "server-access.h"
#include "server-rs.h"
#include "database.h"
#include "query.h"

/* configuration of the general data */
#include "conf-manager.h"

/* main interface callbacks */
#include <libgnomedb/libgnomedb.h>


static gint prepare_app (ConfManager * conf);

extern int xmlDoValidityCheckingDefaultValue;





extern gint set_opened_file (ConfManager * conf, gchar * filetxt);
static gint
prepare_app (ConfManager * conf)
{
	GnomeClient *client;
	gchar *str;

	/* create the objects now that the Corba stuff is initialized */
	conf_manager_finish_prepare (conf);

	gtk_widget_show (conf->app);


	/* session management */
	client = gnome_master_client ();
	g_signal_connect (G_OBJECT (client), "save_yourself",
			  G_CALLBACK (session_save_state_cb), conf);
	g_signal_connect (G_OBJECT (client), "die",
			  G_CALLBACK (session_die_cb), NULL);


	/* getting the previously saved parameters */
	str = settings_get_plugins_dir ();
	if (str)
		conf->plugins_dir = str;
	else
		conf->plugins_dir = g_strdup (PLUGINSINSTALLDIR);
	server_access_rescan_display_plugins (conf->srv, conf->plugins_dir);


	/* analysis of command line parameters */
	if (conf->datasource)
		g_string_assign (conf->srv->gda_datasource, conf->datasource);
	if (conf->user_name)
		g_string_assign (conf->srv->user_name, conf->user_name);
	if (conf->user_passwd)
		g_string_assign (conf->srv->password, conf->user_passwd);

	if (conf->file_to_open)
		set_opened_file (conf, conf->file_to_open);

	return 0;		/* => everything OK */
}

static void
removed_from_session_cb (GnomeClient *session_client, gpointer user_data)
{
	ConfManager *conf = user_data;

	gtk_widget_destroy (GTK_WIDGET (conf->app));
}

static gint
save_session_cb (GnomeClient *session_client, gint phase, GnomeSaveStyle save_style,
		 gint shutdown, GnomeInteractStyle interact_style, gint fast, gpointer user_data)
{
	char **restart_argv;
	int argc, i = 0;
	ConfManager *conf = user_data;

	if (GDA_IS_CONNECTION (conf->srv->cnc) && gda_connection_is_open (conf->srv->cnc)) {
		argc = 3;
		if (conf->user_name && *conf->user_name) {
			argc += 2;
			if (conf->user_passwd && *conf->user_passwd)
				argc += 2;
		}
		if (conf->file_to_open && *conf->file_to_open)
			argc++;

		restart_argv = g_new (char *, argc);
		restart_argv[i++] = g_strdup ("mergeant");
		restart_argv[i++] = g_strdup ("--datasource");
		restart_argv[i++] = g_strdup (conf->datasource);
		if (conf->user_name && *conf->user_name) {
			restart_argv[i++] = g_strdup ("--user");
			restart_argv[i++] = g_strdup (conf->user_name);
			if (conf->user_passwd && *conf->user_passwd) {
				restart_argv[i++] = g_strdup ("--password");
				restart_argv[i++] = g_strdup (conf->user_passwd);
			}
		}

		if (conf->file_to_open && *conf->file_to_open)
			restart_argv[i++] = g_strdup (conf->file_to_open);
	} else {
		argc = 1;
		restart_argv = g_new (char *, argc);
		restart_argv[0] = g_strdup ("mergeant");
	}

	gnome_client_set_restart_command (session_client, argc, restart_argv);

	for (i = 0; i < argc; i++)
		g_free (restart_argv[i]);
	g_free (restart_argv);

	return TRUE;
}

int
main (int argc, char *argv[])
{
	ConfManager *conf;
	GnomeClient *session_client;

	/* Command line options */
	poptContext return_ctx;
	const char **args;
	gchar *ds = NULL, *user = NULL, *pass = NULL;

	struct poptOption options[] = {
		{"datasource", 'd', POPT_ARG_STRING, &ds, 0,
		 N_("datasource name"),
		 N_("SOURCE")},
		{"user", 'u', POPT_ARG_STRING, &user, 0, N_("user name"),
		 N_("USER-NAME")},
		{"password", 'p', POPT_ARG_STRING, &pass, 0, N_("password"),
		 N_("PASSWORD")},
		{NULL, '\0', 0, NULL, 0}	/* end the list */
	};

	/* i18n and i10n */
#ifdef ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	/* CORBA and GNOME init */
	gnome_db_init (PACKAGE, VERSION, argc, argv);
	gnome_init_with_popt_table (PACKAGE,	/* app_id */
				    VERSION,	/* app_version */
				    argc, argv, options,	/* options */
				    0,	/* popt_flags */
				    &return_ctx);	/* return_ctx */

        conf = CONF_MANAGER (conf_manager_new ());

	/* taking care of the command line arguments */
	if (ds)
		conf->datasource = g_strdup (ds);
	if (user)
		conf->user_name = g_strdup (user);
	if (pass)
		conf->user_passwd = g_strdup (pass);

	/* remaining arguments on the command line */
	args = poptGetArgs (return_ctx);
	if (args) {
		if (args[0]) {	/* opens the specified file */
			conf->file_to_open = g_strdup (args[0]);
		}
	}

	/* XML DTD checking */
	xmlDoValidityCheckingDefaultValue = 1;

	/* session management */
	session_client = gnome_master_client ();
	g_signal_connect (G_OBJECT (session_client), "save_yourself",
			  G_CALLBACK (save_session_cb), conf);
	g_signal_connect (G_OBJECT (session_client), "die",
			  G_CALLBACK (removed_from_session_cb), conf);

	/* main loop */
	gnome_db_main_run ((GdaInitFunc) prepare_app, conf);

	return 0;
}
