--
-- TOC Entry ID 2 (OID 16605)
--
-- Name: salesrep_id_seq Type: SEQUENCE
--

CREATE SEQUENCE "salesrep_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 4 (OID 16607)
--
-- Name: customers_id_seq Type: SEQUENCE
--

CREATE SEQUENCE "customers_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 6 (OID 16609)
--
-- Name: orders_id_seq Type: SEQUENCE
--

CREATE SEQUENCE "orders_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 8 (OID 16611)
--
-- Name: warehouses_id_seq Type: SEQUENCE
--

CREATE SEQUENCE "warehouses_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 10 (OID 16613)
--
-- Name: salesrep Type: TABLE
--

CREATE TABLE "salesrep" (
	"id" integer DEFAULT nextval('salesrep_id_seq'::text) NOT NULL,
	"name" character varying(30) NOT NULL,
	"year_salary" integer NOT NULL,
	"date_empl" date NOT NULL,
	Constraint "salesrep_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 11 (OID 16616)
--
-- Name: customers Type: TABLE
--

CREATE TABLE "customers" (
	"id" integer DEFAULT nextval('customers_id_seq'::text) NOT NULL,
	"name" character varying(30) NOT NULL,
	"city" character varying(30),
	"served_by" integer NOT NULL,
	Constraint "customers_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 12 (OID 16625)
--
-- Name: orders Type: TABLE
--

CREATE TABLE "orders" (
	"id" integer DEFAULT nextval('orders_id_seq'::text) NOT NULL,
	"customer_id" integer NOT NULL,
	"creation_date" date NOT NULL,
	"delivery_before" date,
	"delivery_at" date,
	Constraint "orders_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 13 (OID 16634)
--
-- Name: warehouses Type: TABLE
--

CREATE TABLE "warehouses" (
	"id" integer DEFAULT nextval('warehouses_id_seq'::text) NOT NULL,
	"name" character varying(30) NOT NULL,
	"location" character varying(30),
	Constraint "warehouses_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 14 (OID 16637)
--
-- Name: products Type: TABLE
--

CREATE TABLE "products" (
	"ref" character varying(15) NOT NULL,
	"name" character varying(20) NOT NULL,
	"price" double precision,
	"wh_stored" integer,
	Constraint "products_pkey" Primary Key ("ref")
);

--
-- TOC Entry ID 15 (OID 16646)
--
-- Name: order_contents Type: TABLE
--

CREATE TABLE "order_contents" (
	"order_id" integer NOT NULL,
	"product_ref" character varying(15) NOT NULL,
	"qty" integer,
	"discount" double precision,
	Constraint "order_contents_pkey" Primary Key ("order_id")
);

--
-- Data for TOC Entry ID 20 (OID 16613)
--
-- Name: salesrep Type: TABLE DATA
--


INSERT INTO "salesrep" VALUES (1,'John Doe',300,'2001-06-01');
INSERT INTO "salesrep" VALUES (2,'Allan Parkson',320,'2001-06-15');
INSERT INTO "salesrep" VALUES (3,'Ben Callaway',250,'2001-06-15');
--
-- Data for TOC Entry ID 21 (OID 16616)
--
-- Name: customers Type: TABLE DATA
--


INSERT INTO "customers" VALUES (2,'Mad Max','Dallas',2);
INSERT INTO "customers" VALUES (3,'Brian Dawson','Chicago',1);
INSERT INTO "customers" VALUES (1,'Franck Pallo','New York',1);
--
-- Data for TOC Entry ID 22 (OID 16625)
--
-- Name: orders Type: TABLE DATA
--


INSERT INTO "orders" VALUES (1,2,'2001-06-07',NULL,NULL);
--
-- Data for TOC Entry ID 23 (OID 16634)
--
-- Name: warehouses Type: TABLE DATA
--


INSERT INTO "warehouses" VALUES (1,'Main Storage building','NYC');
INSERT INTO "warehouses" VALUES (2,'Rented storage area','San Francisco');
--
-- Data for TOC Entry ID 24 (OID 16637)
--
-- Name: products Type: TABLE DATA
--


INSERT INTO "products" VALUES ('CHA001','Small red Chair',123.56,1);
INSERT INTO "products" VALUES ('CHA002','Big red armchair',256.75,1);
INSERT INTO "products" VALUES ('TAB001','Large Wood table',230,1);
INSERT INTO "products" VALUES ('TV001','Small color TV',120.2,2);
--
-- Data for TOC Entry ID 25 (OID 16646)
--
-- Name: order_contents Type: TABLE DATA
--


--
-- TOC Entry ID 16 (OID 16671)
--
-- Name: "salesrep_id_key" Type: INDEX
--

CREATE UNIQUE INDEX salesrep_id_key ON salesrep USING btree (id);

--
-- TOC Entry ID 17 (OID 16672)
--
-- Name: "customers_id_key" Type: INDEX
--

CREATE UNIQUE INDEX customers_id_key ON customers USING btree (id);

--
-- TOC Entry ID 18 (OID 16673)
--
-- Name: "orders_id_key" Type: INDEX
--

CREATE UNIQUE INDEX orders_id_key ON orders USING btree (id);

--
-- TOC Entry ID 19 (OID 16674)
--
-- Name: "warehouses_id_key" Type: INDEX
--

CREATE UNIQUE INDEX warehouses_id_key ON warehouses USING btree (id);

--
-- TOC Entry ID 28 (OID 16620)
--
-- Name: "RI_ConstraintTrigger_16619" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "customers"  FROM "salesrep" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'customers', 'salesrep', 'UNSPECIFIED', 'served_by', 'id');

--
-- TOC Entry ID 26 (OID 16622)
--
-- Name: "RI_ConstraintTrigger_16621" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "salesrep"  FROM "customers" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_noaction_del" ('<unnamed>', 'customers', 'salesrep', 'UNSPECIFIED', 'served_by', 'id');

--
-- TOC Entry ID 27 (OID 16624)
--
-- Name: "RI_ConstraintTrigger_16623" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "salesrep"  FROM "customers" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'customers', 'salesrep', 'UNSPECIFIED', 'served_by', 'id');

--
-- TOC Entry ID 31 (OID 16629)
--
-- Name: "RI_ConstraintTrigger_16628" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "orders"  FROM "customers" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'orders', 'customers', 'UNSPECIFIED', 'customer_id', 'id');

--
-- TOC Entry ID 29 (OID 16631)
--
-- Name: "RI_ConstraintTrigger_16630" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "customers"  FROM "orders" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_noaction_del" ('<unnamed>', 'orders', 'customers', 'UNSPECIFIED', 'customer_id', 'id');

--
-- TOC Entry ID 30 (OID 16633)
--
-- Name: "RI_ConstraintTrigger_16632" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "customers"  FROM "orders" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'orders', 'customers', 'UNSPECIFIED', 'customer_id', 'id');

--
-- TOC Entry ID 34 (OID 16641)
--
-- Name: "RI_ConstraintTrigger_16640" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "products"  FROM "warehouses" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'products', 'warehouses', 'UNSPECIFIED', 'wh_stored', 'id');

--
-- TOC Entry ID 32 (OID 16643)
--
-- Name: "RI_ConstraintTrigger_16642" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "warehouses"  FROM "products" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_noaction_del" ('<unnamed>', 'products', 'warehouses', 'UNSPECIFIED', 'wh_stored', 'id');

--
-- TOC Entry ID 33 (OID 16645)
--
-- Name: "RI_ConstraintTrigger_16644" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "warehouses"  FROM "products" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'products', 'warehouses', 'UNSPECIFIED', 'wh_stored', 'id');

--
-- TOC Entry ID 37 (OID 16650)
--
-- Name: "RI_ConstraintTrigger_16649" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "order_contents"  FROM "products" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'order_contents', 'products', 'UNSPECIFIED', 'product_ref', 'ref');

--
-- TOC Entry ID 35 (OID 16652)
--
-- Name: "RI_ConstraintTrigger_16651" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "products"  FROM "order_contents" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_noaction_del" ('<unnamed>', 'order_contents', 'products', 'UNSPECIFIED', 'product_ref', 'ref');

--
-- TOC Entry ID 36 (OID 16654)
--
-- Name: "RI_ConstraintTrigger_16653" Type: TRIGGER
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "products"  FROM "order_contents" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'order_contents', 'products', 'UNSPECIFIED', 'product_ref', 'ref');

--
-- TOC Entry ID 3 (OID 16605)
--
-- Name: salesrep_id_seq Type: SEQUENCE SET
--

SELECT setval ('"salesrep_id_seq"', 3, true);

--
-- TOC Entry ID 5 (OID 16607)
--
-- Name: customers_id_seq Type: SEQUENCE SET
--

SELECT setval ('"customers_id_seq"', 3, true);

--
-- TOC Entry ID 7 (OID 16609)
--
-- Name: orders_id_seq Type: SEQUENCE SET
--

SELECT setval ('"orders_id_seq"', 1, true);

--
-- TOC Entry ID 9 (OID 16611)
--
-- Name: warehouses_id_seq Type: SEQUENCE SET
--

SELECT setval ('"warehouses_id_seq"', 2, true);

