/* data-form.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __DATA_FORM__
#define __DATA_FORM__

#include <gnome.h>
#include <config.h>
#include "query-exec.h"

G_BEGIN_DECLS

#define DATA_FORM_TYPE          (data_form_get_type())
#define DATA_FORM(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, data_form_get_type(), DataForm)
#define DATA_FORM_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, data_form_get_type (), DataFormClass)
#define IS_DATA_FORM(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, data_form_get_type ())


typedef struct _DataForm      DataForm;
typedef struct _DataFormClass DataFormClass;
typedef struct _DataFormPriv  DataFormPriv;


/* struct for the object's data */
struct _DataForm
{
	GtkVBox       object;

	DataFormPriv *priv;
};

/* struct for the object's class */
struct _DataFormClass
{
	GtkVBoxClass            parent_class;
	
	void (*action_refresh)    (DataForm * df);
	void (*action_insert)     (DataForm * df);
	void (*action_viewall)    (DataForm * df);
	void (*action_choose)     (DataForm * df, gulong row);
	void (*contents_modified) (DataForm * df);
};

/* widget's methods */
guint      data_form_get_type          (void);
GtkWidget *data_form_new_edit          (QueryExec *qx, gulong numrow);
GtkWidget *data_form_new_insert        (QueryExec *qx);
GtkWidget *data_form_new_browse        (QueryExec *qx, gulong numrow);
GtkWidget *data_form_new_select        (QueryExec *qx, QueryView *qv, gulong numrow);

void       data_form_refresh           (DataForm *form);

G_END_DECLS

#endif
