/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */

/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

#ifndef __MLVIEW_XML_DOCUMENT_VIEW_H__
#  define __MLVIEW_XML_DOCUMENT_VIEW_H__

#  include "mlview-app-context.h"
#  include "mlview-xml-document.h"

G_BEGIN_DECLS
/************************************************
 *This class is only the base class of all the 
 *views of an MlViewXMLDocument.
 ************************************************/
#  define MLVIEW_TYPE_XML_DOCUMENT_VIEW (mlview_xml_document_view_get_type ())
#  define MLVIEW_XML_DOCUMENT_VIEW(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), MLVIEW_TYPE_XML_DOCUMENT_VIEW, MlViewXMLDocumentView))
#  define MLVIEW_XML_DOCUMENT_VIEW_CLASS(object) (G_TYPE_CHECK_CLASS_CAST ((klass), MVLIEW_TYPE_XML_DOCUMENT_VIEW, MlViewXMLDocumentViewClass))
#  define MLVIEW_IS_XML_DOCUMENT_VIEW(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), MLVIEW_TYPE_XML_DOCUMENT_VIEW))
#  define MLVIEW_IS_XML_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MLVIEW_TYPE_XML_DOCUMENT_VIEW))
typedef struct _MlViewXMLDocumentView MlViewXMLDocumentView;

typedef struct _MlViewXMLDocumentViewClass
 MlViewXMLDocumentViewClass;

typedef struct _MlViewXMLDocumentViewPrivate
 MlViewXMLDocumentViewPrivate;

struct _SignalCallbackDescriptor {
        const guchar *signal_name;
        GtkSignalFunc signal_handler;
};

typedef struct _SignalCallbackDescriptor
 SignalCallbackDescriptor;

enum MLVIEW_XML_DOCUMENT_VIEW_STATUS {
        MLVIEW_XML_DOCUMENT_VIEW_OK,
        MLVIEW_XML_DOCUMENT_VIEW_NOK,
        MLVIEW_XML_DOCUMENT_VIEW_DOC_SIGNAL_HANDLERS_NOT_SET,
        MLVIEW_XML_DOCUMENT_VIEW_BAD_PARAMETER
};

struct _MlViewXMLDocumentView {
        GtkVBox box;
        MlViewXMLDocumentViewPrivate *priv;
};

struct _MlViewXMLDocumentViewClass {
        GtkVBoxClass parent_class;

        /*Document view signals */
        void (*name_changed) (MlViewXMLDocumentView * a_view,
                              gpointer a_user_data);
};

gint mlview_xml_document_view_get_type (void);

enum MLVIEW_XML_DOCUMENT_VIEW_STATUS
 mlview_xml_document_view_construct
        (MlViewXMLDocumentView * a_doc_view,
         MlViewXMLDocument * a_mlview_xml_doc);

MlViewXMLDocumentView
        * mlview_xml_document_view_new (MlViewXMLDocument *
                                        a_mlview_doc);

void
 mlview_xml_document_view_ref (MlViewXMLDocumentView * a_this);

void
 mlview_xml_document_view_unref (MlViewXMLDocumentView * a_this);

void
 mlview_xml_document_view_set_document_signal_handlers
        (SignalCallbackDescriptor * a_signals);

void
 mlview_xml_document_view_set_name
        (MlViewXMLDocumentView * a_view, gchar * a_name);

void
 mlview_xml_document_view_set_name_interactive
        (MlViewXMLDocumentView * a_view);

gchar *mlview_xml_document_view_get_name (MlViewXMLDocumentView *
                                          a_view);

MlViewXMLDocument *mlview_xml_document_view_get_document
        (MlViewXMLDocumentView * a_doc_view);

void
 mlview_xml_document_view_set_document
        (MlViewXMLDocumentView * a_doc_view,
         MlViewXMLDocument * a_mlview_doc);

MlViewFileDescriptor
        * mlview_xml_document_view_get_file_descriptor
        (MlViewXMLDocumentView * a_doc_view);

void
 mlview_xml_document_view_destroy (GtkObject * a_mlview_xml_doc_view);

G_END_DECLS
#endif /*__MLVIEW_XML_DOCUMENT_VIEW_H__*/
