/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

#ifndef __MLVIEW_GLOBAL_SETTINGS_H__
#define __MLVIEW_GLOBAL_SETTINGS_H__

#include <glib.h>

G_BEGIN_DECLS
/*###########################################################
 *here goes the application wide settings keys and values.
 *As these settings are put in a hash table, i think it is good
 *to store them as strings. That is good for extensibility.
 *##########################################################*/
/************************************************************************
 *possible settings hash table keys. These values are all
 *prefixed with MLVIEW_STG_K which stands for "mlview settings key"
 ***********************************************************************/
        /*wether if validation is on/off. possible values are MLVIEW_STG_V_YES or MLVIEW_STG_V_NO */
extern const char *MLVIEW_STG_K_IS_VALIDATION_ON;

        /*the default tree expansion level */
extern const char
*MLVIEW_STG_K_DEFAULT_TREE_EXPANSION_LEVEL;

extern const char *MLVIEW_STG_K_PIXMAPS_DIR;
extern const char *MLVIEW_STG_K_ICON_PATH;
extern const char *MLVIEW_STG_K_OPEN_ELEMENT_NODE_XPM;
extern const char *MLVIEW_STG_K_CLOSE_ELEMENT_NODE_XPM;
extern const char *MLVIEW_STG_K_TEXT_NODE_XPM;
extern const char *MLVIEW_STG_K_OPEN_ELEMENT_NODE_BPM;
extern const char *MLVIEW_STG_K_CLOSE_ELEMENT_NODE_BPM;
extern const char *MLVIEW_STG_K_TEXT_NODE_BPM;
extern const char *MLVIEW_STG_K_XML_CATALOG;

/***********************************************************************
 *possible settings hash table values. These values are all prefixed with MLVIEW_STG_V 
 *which stands for "mlview settings value".
 ***********************************************************************/

extern const char *MLVIEW_STG_V_YES;
extern const char *MLVIEW_STG_V_NO;
extern const char
*MLVIEW_STG_V_DEFAULT_TREE_EXPANSION_LEVEL;
extern const char *MLVIEW_STG_V_PIXMAPS_DIR;
extern const char *MLVIEW_STG_V_ICON_PATH;
extern const char *MLVIEW_STG_V_OPEN_ELEMENT_NODE_XPM;
extern const char *MLVIEW_STG_V_CLOSE_ELEMENT_NODE_XPM;
extern const char *MLVIEW_STG_V_TEXT_NODE_XPM;

/**********************************************************
 *Other application wide constants.
 **********************************************************/

G_END_DECLS
       /*__cplusplus*/
#endif
