/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */
/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

#ifndef __MLVIEW_NAMESPACE_EDITOR_H__
#  define __MLVIEW_NAMESPACE_EDITOR_H__

#  include <libxml/tree.h>
#  include "mlview-app-context.h"

G_BEGIN_DECLS
#  define MLVIEW_TYPE_NAMESPACE_EDITOR (mlview_namespace_editor_get_type())
#  define MLVIEW_NAMESPACE_EDITOR(object) (GTK_CHECK_CAST(object, MLVIEW_TYPE_NAMESPACE_EDITOR, MlViewNamespaceEditor))
#  define MLVIEW_NAMESPACE_EDITOR_CLASS(klass) (GTK_CHECK_CLASS_CAST(klass, MLVIEW_TYPE_NAMESPACE_EDITOR, MlViewNamespaceEditorClass))
#  define MLVIEW_IS_NAMESPACE_EDITOR(object) (GTK_CHECK_TYPE(object, MLVIEW_TYPE_NAMESPACE_EDITOR))
#  define MLVIEW_IS_NAMESPACE_EDITOR_CLASS(klass) (GTK_CHECK_CLASS_CAST(klass, MLVIEW_TYPE_NAMESPACE_EDITOR))
typedef struct _MlViewNamespaceEditor MlViewNamespaceEditor;
typedef struct _MlViewNamespaceEditorClass
 MlViewNamespaceEditorClass;
typedef struct _MlViewNamespaceEditorPrivate
 MlViewNamespaceEditorPrivate;

struct _MlViewNamespaceEditor {
        GtkVBox container;      /*parent object */
        MlViewNamespaceEditorPrivate *private;
};

struct _MlViewNamespaceEditorClass {
        GtkVBoxClass parent_class;
        void (*namespace_added) (MlViewNamespaceEditor *
                                 a_editor, xmlNs * a_namespace,
                                 gpointer a_data);
        void (*namespace_prefix_changed) (MlViewNamespaceEditor *
                                          a_editor,
                                          xmlNs * a_namespace,
                                          gpointer a_data);
        void (*namespace_uri_changed) (MlViewNamespaceEditor *
                                       a_editor,
                                       xmlNs * a_namespace,
                                       gpointer a_data);
        void (*namespace_changed) (MlViewNamespaceEditor *
                                   a_editor, xmlNs * a_namespace,
                                   gpointer a_data);
        void (*namespace_deleted) (MlViewNamespaceEditor *
                                   a_editor, xmlNs * a_namespace,
                                   gpointer a_data);
};

guint mlview_namespace_editor_get_type (void);

GtkWidget *mlview_namespace_editor_new (MlViewAppContext *
                                        a_app_context);

void
 mlview_namespace_editor_edit_node_visible_namespaces
        (MlViewNamespaceEditor * a_editor, xmlNode * a_xml_node);

void mlview_namespace_editor_clear (MlViewNamespaceEditor *
                                    a_editor);

xmlNs *mlview_namespace_editor_get_current_selected_ns
        (MlViewNamespaceEditor * a_editor);

xmlNode *mlview_namespace_editor_get_current_xml_node
        (MlViewNamespaceEditor * a_editor);

xmlNs *mlview_namespace_editor_add_namespace_def
        (MlViewNamespaceEditor * a_editor, gchar * a_ns_prefix,
         gchar * a_ns_uri, xmlNode * a_xml_node);

void
 mlview_namespace_editor_remove_namespace_def
        (MlViewNamespaceEditor * a_editor, xmlNs * a_ns,
         xmlNode * a_xml_node);

G_END_DECLS
#endif/*__MLVIEW_NAMESPACE_EDITOR_H__*/
