/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

/**
 *changes that occur on the xmlNode. This signals could be catched by a higher level editor that would update a tree or something. This class
 *should provide facilities to attach objects to it, so that the higher level editors that use it could easily associates a visual tree node to
 *an xmlNode being edited. It would be then easier to update the matching visual node when an xmlNode is modified.
 *THAT WOULD BE FAR BETTER THAN NOW !!! 
 *
 */

#ifndef __MLVIEW_NODE_EDITOR_H__
#  define __MLVIEW_NODE_EDITOR_H__

#  include <libxml/tree.h>
#  include "mlview-app-context.h"
#  include "mlview-xml-document.h"

#  ifdef __cplusplus
extern "C" {
#  endif
       /*__cplusplus*/


#  define MLVIEW_TYPE_NODE_EDITOR (mlview_node_editor_get_type())
#  define MLVIEW_NODE_EDITOR(object) (GTK_CHECK_CAST((object), MLVIEW_TYPE_NODE_EDITOR, MlViewNodeEditor))
#  define MLVIEW_NODE_EDITOR_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), MLVIEW_TYPE_NODE_EDITOR, MlViewNodeEditorClass))
#  define MLVIEW_IS_NODE_EDITOR(object) (GTK_CHECK_TYPE((object), MLVIEW_TYPE_NODE_EDITOR))
#  define MLVIEW_IS_NODE_EDITOR_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), MLVIEW_TYPE_NODE_EDITOR))

        typedef struct _MlViewNodeEditorPrivate
         MlViewNodeEditorPrivate;
        typedef struct _MlViewNodeEditor MlViewNodeEditor;
        typedef struct _MlViewNodeEditorClass
         MlViewNodeEditorClass;

/*======================================================================
 *The structure representing the MlViewNodeEditor object which inherits a GtkHPaned.
 *=====================================================================*/
        struct _MlViewNodeEditor {
                GtkHPaned hpaned; /*inherits a GtkVPaned */
                MlViewNodeEditorPrivate *private;
        };

/*=======================================================================
 *The exported methods of the MlViewELementEditor object.
 *=======================================================================*/
        guint mlview_node_editor_get_type (void);

        GtkWidget *mlview_node_editor_new (MlViewAppContext *
                                           a_app_context);

        void
         mlview_node_editor_set_application_context
                (MlViewNodeEditor * a_node_editor,
                 MlViewAppContext * a_app_context);

         MlViewAppContext
                * mlview_node_editor_get_application_context
                (MlViewNodeEditor * a_node_editor);

         xmlNodePtr
                mlview_node_editor_get_current_xml_node
                (MlViewNodeEditor * a_editor);

        void
         mlview_node_editor_edit_xml_node (MlViewNodeEditor *
                                           a_editor,
                                           MlViewXMLDocument *
                                           a_xml_doc,
                                           xmlNode * a_node);

        void
         mlview_node_editor_clear (MlViewNodeEditor * a_editor);

        void
         mlview_node_editor_set_editable (MlViewNodeEditor *
                                          a_editor,
                                          gboolean a_editable);

         gpointer
                mlview_node_editor_get_attached_object
                (MlViewNodeEditor * a_editor, gchar * a_key);

        void
         mlview_node_editor_set_left_right_percentage
                (MlViewNodeEditor * a_node_editor,
                 const guint a_percentage);

        struct _MlViewNodeEditorClass {
                GtkHPanedClass parent_class;
                /*signal default handlers */
                void (*element_changed) (MlViewNodeEditor *
                                         a_editor,
                                         gpointer a_data);
                void (*element_name_changed) (MlViewNodeEditor *
                                              a_editor,
                                              xmlNodePtr a_node);
                void (*element_attribute_changed)
                 (MlViewNodeEditor * a_editor,
                  xmlNodePtr a_node);
                void (*element_content_changed) (MlViewNodeEditor
                                                 * a_editor,
                                                 xmlNodePtr
                                                 a_node);
                void (*edit_state_changed) (MlViewNodeEditor *
                                            a_editor);
        };

#  ifdef __cplusplus
}
#  endif
       /*__cplusplus*/
#endif /*__MLVIEW_NODE_EDITOR_H__*/
