/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*This file is part of GNU MlView
 *
 *GNU MlView is free software; 
 *you can redistribute it and/or modify it under the terms of 
 *the GNU General Public License as 
 *published by the Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope 
 *that it will be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright information.
 */

#ifndef __MLVIEW_EDITOR_H__
#define __MLVIEW_EDITOR_H__

#include <libxml/parser.h>
#include "mlview-node-editor.h"
#include "mlview-file-selection.h"
#include "mlview-app-context.h"
#include "mlview-xml-document.h"
#include "mlview-iview.h"
#include "mlview-action.h"

G_BEGIN_DECLS

/**
 *@file
 *The declaration of the #MlViewEditor class.
 *
 */

/*
 *Macros for casting a GtkWidget or 
 *GtkWidgetClass pointer to a MlViewEditor 
 *or MlviewClass pointer.
 *Macros for testing wheter 'widget' or 'klass' are of 
 *type MLVIEW_TYPE_EDITOR.
 */
#  define MLVIEW_TYPE_EDITOR (mlview_editor_get_type ())
#  define MLVIEW_EDITOR(widget) (G_TYPE_CHECK_INSTANCE_CAST ((widget), MLVIEW_TYPE_EDITOR, MlViewEditor))
#  define MLVIEW_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MLVIEW_TYPE_EDITOR, MlViewEditorClass))
#  define MLVIEW_IS_EDITOR(widget) (G_TYPE_CHECK_INSTANCE_TYPE ((widget), MLVIEW_TYPE_EDITOR))
#  define MLVIEW_IS_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MLVIEW_TYPE_EDITOR))
typedef struct _MlViewEditorPrivate MlViewEditorPrivate;
typedef struct _MlViewEditor MlViewEditor;
typedef struct _MlViewEditorClass MlViewEditorClass;



/**
 *The data members of the class
 *#MlViewEditor.
 *This class is the abstraction of the mlview editor.
 *An mlview editor is basically a container of views.
 *It main goal is to select the view the user wants 
 *to work on, 
 *an send the requests of the that user to the view.
 */
struct _MlViewEditor {
         /**The parent class*/
        GtkVBox box;

         /**the private members data structure*/
        MlViewEditorPrivate *priv;
};

/**
 *#MlViewEditor class vtable.
 *
 */
struct _MlViewEditorClass {
         /**The parent class's vtable*/
        GtkVBoxClass parent_class;
         /**
          *"document-changed" signal's default handler.
          */
        void (*document_changed) (MlViewEditor * a_editor,
                                  gpointer a_data);

        void (*last_view_removed)  (MlViewEditor *a_editor,
                                   gpointer a_data) ;

        void (*first_view_added) (MlViewEditor *a_editor,
                                  MlViewIView *a_this,
                                  gpointer a_data) ;
};


GType mlview_editor_get_type (void) ;

GtkWidget *mlview_editor_new (const guchar * a_title,
                              MlViewAppContext * a_context);

MlViewIView * mlview_editor_create_new_view_on_document (MlViewEditor *a_editor,
                                                         MlViewXMLDocument *a_xml_doc) ;

MlViewIView * mlview_editor_create_new_view_on_document2 (MlViewEditor *a_this,
		                                          MlViewXMLDocument *a_doc,
					                  const gchar *a_view_desc_type_name) ;

MlViewIView *mlview_editor_create_new_view_on_document3 (MlViewEditor *a_this,
		                                         MlViewXMLDocument *a_doc,
							 struct MlViewViewDesc *a_desc);

MlViewIView *mlview_editor_create_new_view_on_current_document (MlViewEditor *a_this,
								struct MlViewViewDesc*); 

MlViewIView * mlview_editor_create_new_view_on_current_document_interactive  (MlViewEditor * a_editor);

MlViewIView * mlview_editor_get_current_document_view (MlViewEditor * a_this);

enum MlViewStatus mlview_editor_add_view_at_index (MlViewEditor *a_this,
						   MlViewIView *a_view,
						   glong a_index) ;

void mlview_editor_add_view (MlViewEditor * a_editor,
                             MlViewIView *a_iview);

void mlview_editor_remove_view (MlViewEditor * a_editor,
                                MlViewIView *a_view);

enum MlViewStatus mlview_editor_rebuild_view (MlViewEditor *a_this,
					      MlViewIView *a_view,
					      MlViewIView **a_new_view) ;

MlViewXMLDocument *mlview_editor_get_current_document (MlViewEditor *a_this);

GList *mlview_editor_get_list_of_open_documents (MlViewEditor * a_this);

void mlview_editor_load_xml_file (MlViewEditor * a_editor,
                                  const gchar * a_file_path,
				  gboolean a_interactive);

void mlview_editor_load_xml_file_with_dtd (MlViewEditor * a_this,
                                           const gchar * a_file_path,
                                           const gchar * a_dtd_path,
					   gboolean a_disable_interaction);

enum MlViewStatus mlview_editor_reload_document (MlViewEditor *a_this,
		                                 gboolean a_interactive) ;

void mlview_editor_open_xml_document_interactive (MlViewEditor * editor);

void mlview_editor_open_local_xml_document_interactive (MlViewEditor * editor);


void mlview_editor_set_current_view_name (MlViewEditor * a_editor,
                                          gchar * a_name);

void mlview_editor_set_current_view_name_interactive (MlViewEditor * a_editor);

void mlview_editor_add_child_node_interactive (MlViewEditor * a_editor);

void mlview_editor_insert_sibling_node_interactive (MlViewEditor * a_editor);

void mlview_editor_insert_prev_sibling_node_interactive (MlViewEditor * a_editor);

void mlview_editor_insert_next_sibling_node_interactive (MlViewEditor * a_editor);

void mlview_editor_cut_node (MlViewEditor * a_editor);

void mlview_editor_copy_node (MlViewEditor * a_editor);

xmlDocPtr mlview_editor_get_current_xml_doc (MlViewEditor * a_editor);

void mlview_editor_edit_xml_document (MlViewEditor * a_editor,
                                      xmlDocPtr a_doc,
                                      gchar * a_doc_name);

void mlview_editor_save_xml_document (MlViewEditor * a_editor);

void mlview_editor_save_xml_document_as (MlViewEditor * a_editor,
                                         gchar * a_file_path);

void mlview_editor_save_xml_document_as_interactive (MlViewEditor * a_editor);

gchar *mlview_editor_get_current_xml_doc_file_path (MlViewEditor
                                                    * a_editor);

void mlview_editor_close_xml_document_without_saving (MlViewEditor * a_editor);

void mlview_editor_save_and_close_xml_document (MlViewEditor * a_editor);

void mlview_editor_create_new_xml_document (MlViewEditor * a_editor);

void mlview_editor_close_xml_document (MlViewEditor * a_editor,
		                       gboolean a_interactive);

gboolean mlview_editor_close_all_xml_documents (MlViewEditor * a_editor,
		                                gboolean a_interactive);

void mlview_editor_paste_node_as_prev_sibling (MlViewEditor * a_editor);

void mlview_editor_paste_node_as_child (MlViewEditor * a_editor);

void mlview_editor_paste_node_as_next_sibling (MlViewEditor * a_editor);

void mlview_editor_expand_tree_to_depth_interactive (MlViewEditor * a_editor);

void mlview_editor_edit_settings_interactive (MlViewEditor * a_editor);

MlViewFileSelection* mlview_editor_get_file_selector (MlViewEditor *a_editor,
                                                      gchar * a_title);

gint mlview_editor_manage_associated_schemas (MlViewEditor *a_editor);

void mlview_editor_validate (MlViewEditor * a_editor);

void mlview_editor_set_app_context (MlViewEditor * a_editor,
                                    MlViewAppContext * a_context);

MlViewAppContext *mlview_editor_get_app_context (MlViewEditor * a_editor);

enum MlViewStatus mlview_editor_execute_action (MlViewEditor *a_this,
                                                MlViewAction *a_action) ;

void mlview_editor_xslt_transform_document_interactive (MlViewEditor *a_this);

enum MlViewStatus mlview_editor_get_default_view_descriptor 
					(MlViewEditor *a_this,
                                         struct MlViewViewDesc **a_view_desc) ;

struct MlViewViewDesc * mlview_editor_peek_editing_view_descriptor 
				(gchar *a_view_type_name) ;

guint mlview_editor_get_number_of_view_desc (void) ;

struct MlViewViewDesc * mlview_editor_get_view_descriptor_at (guint a_offset) ;

gint mlview_editor_get_number_of_views_opened_with_doc (MlViewEditor *a_this,
                                                        MlViewXMLDocument *a_doc);

GtkWidget *mlview_editor_show_schemas_window_for_doc (MlViewEditor *a_this,
                                                      MlViewXMLDocument *a_doc);

GtkWidget *mlview_editor_show_validation_window_for_doc (MlViewEditor *a_this,
                                                         MlViewXMLDocument *a_doc);

enum MlViewStatus mlview_editor_make_current_view_populate_application_edit_menu 
							(MlViewEditor *a_this) ;

enum MlViewStatus mlview_editor_is_document_opened_in_editor 
				(MlViewEditor *a_this,
                                 gchar *a_doc_absolute_path,
                                 gboolean *a_result) ;

enum MlViewStatus mlview_editor_undo (MlViewEditor *a_this) ;

enum MlViewStatus mlview_editor_redo (MlViewEditor *a_this) ;

gboolean mlview_editor_can_undo (MlViewEditor *a_this) ;

gboolean mlview_editor_can_redo (MlViewEditor *a_this) ;

G_END_DECLS
#endif /*__MLVIEW_EDITOR_H__*/
