/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*This file is part of GNU MlView
 *
 *GNU MlView is free software; 
 *you can redistribute it and/or modify it under the terms of 
 *the GNU General Public License as 
 *published by the Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope 
 *that it will be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright information.
 */

#ifndef __MLVIEW_VALIDATION_OUTPUT_H__
#define __MLVIEW_VALIDATION_OUTPUT_H__

#include <libxml/tree.h>

#include "mlview-xml-document.h"

G_BEGIN_DECLS

typedef struct _MlViewValidationMessage MlViewValidationMessage;
typedef struct _MlViewValidationOutput MlViewValidationOutput;

struct _MlViewValidationMessage {
        xmlNodePtr node;
        gchar *message;
        xmlErrorLevel priority;
        xmlElementType type;
};

struct _MlViewValidationOutput {
        GArray *messages;
        MlViewXMLDocument *document;
};

MlViewValidationOutput *mlview_validation_output_new (MlViewXMLDocument *a_doc);      

void mlview_validation_output_free (MlViewValidationOutput *a_this);

G_END_DECLS

#endif
