
#include <src/ReceiveChooserDialog.h>
#include "src/MoUtils.h"




struct _moserialReceiveChooserDialogPrivate {
	GtkBuilder* _builder;
	GtkFileChooserDialog* dialog;
};

#define MOSERIAL_RECEIVE_CHOOSER_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG, moserialReceiveChooserDialogPrivate))
enum  {
	MOSERIAL_RECEIVE_CHOOSER_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_RECEIVE_CHOOSER_DIALOG_BUILDER
};
static void moserial_receive_chooser_dialog_response (moserialReceiveChooserDialog* self, GtkWidget* w, gint r);
static void moserial_receive_chooser_dialog_set_builder (moserialReceiveChooserDialog* self, GtkBuilder* value);
static gboolean _moserial_receive_chooser_dialog_hide_gtk_widget_delete_event (GtkFileChooserDialog* _sender, const GdkEvent* event, gpointer self);
static void _moserial_receive_chooser_dialog_response_gtk_dialog_response (GtkFileChooserDialog* _sender, gint response_id, gpointer self);
static GObject * moserial_receive_chooser_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer moserial_receive_chooser_dialog_parent_class = NULL;
static void moserial_receive_chooser_dialog_finalize (GObject* obj);



moserialReceiveChooserDialog* moserial_receive_chooser_dialog_construct (GType object_type, GtkBuilder* builder) {
	GParameter * __params;
	GParameter * __params_it;
	moserialReceiveChooserDialog * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialReceiveChooserDialog* moserial_receive_chooser_dialog_new (GtkBuilder* builder) {
	return moserial_receive_chooser_dialog_construct (MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG, builder);
}


void moserial_receive_chooser_dialog_show (moserialReceiveChooserDialog* self, const char* folder) {
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	_tmp0 = FALSE;
	if (folder != NULL) {
		_tmp0 = mo_utils_fileExists (folder);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) self->priv->dialog, folder);
	}
	gtk_dialog_run ((GtkDialog*) self->priv->dialog);
}


gboolean moserial_receive_chooser_dialog_hide (moserialReceiveChooserDialog* self, GtkWidget* w) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	gtk_widget_hide ((GtkWidget*) self->priv->dialog);
	return TRUE;
}


static void moserial_receive_chooser_dialog_response (moserialReceiveChooserDialog* self, GtkWidget* w, gint r) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	if (r == GTK_RESPONSE_CANCEL) {
		moserial_receive_chooser_dialog_hide (self, w);
	} else {
		if (r == GTK_RESPONSE_ACCEPT) {
			char* _tmp1;
			const char* _tmp0;
			moserial_receive_chooser_dialog_hide (self, w);
			_tmp1 = NULL;
			_tmp0 = NULL;
			self->path = (_tmp1 = (_tmp0 = gtk_file_chooser_get_current_folder ((GtkFileChooser*) self->priv->dialog), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->path = (g_free (self->path), NULL), _tmp1);
			g_signal_emit_by_name (self, "start-transfer");
		} else {
		}
	}
}


GtkBuilder* moserial_receive_chooser_dialog_get_builder (moserialReceiveChooserDialog* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_builder;
}


static void moserial_receive_chooser_dialog_set_builder (moserialReceiveChooserDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp2;
	GtkBuilder* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_builder = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "builder");
}


static gboolean _moserial_receive_chooser_dialog_hide_gtk_widget_delete_event (GtkFileChooserDialog* _sender, const GdkEvent* event, gpointer self) {
	return moserial_receive_chooser_dialog_hide (self, _sender);
}


static void _moserial_receive_chooser_dialog_response_gtk_dialog_response (GtkFileChooserDialog* _sender, gint response_id, gpointer self) {
	moserial_receive_chooser_dialog_response (self, _sender, response_id);
}


static GObject * moserial_receive_chooser_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialReceiveChooserDialogClass * klass;
	GObjectClass * parent_class;
	moserialReceiveChooserDialog * self;
	klass = MOSERIAL_RECEIVE_CHOOSER_DIALOG_CLASS (g_type_class_peek (MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_RECEIVE_CHOOSER_DIALOG (obj);
	{
		GtkFileChooserDialog* _tmp1;
		GtkFileChooserDialog* _tmp0;
		GtkComboBox* _tmp3;
		GtkComboBox* _tmp2;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->dialog = (_tmp1 = (_tmp0 = GTK_FILE_CHOOSER_DIALOG (gtk_builder_get_object (self->priv->_builder, "receive_chooser_dialog")), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL)), _tmp1);
		_tmp3 = NULL;
		_tmp2 = NULL;
		self->protocolCombo = (_tmp3 = (_tmp2 = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "receive_chooser_protocol")), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (self->protocolCombo == NULL) ? NULL : (self->protocolCombo = (g_object_unref (self->protocolCombo), NULL)), _tmp3);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_receive_chooser_dialog_hide_gtk_widget_delete_event, self, 0);
		gtk_dialog_add_buttons ((GtkDialog*) self->priv->dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, NULL, NULL);
		gtk_combo_box_set_active (self->protocolCombo, 2);
		g_signal_connect_object ((GtkDialog*) self->priv->dialog, "response", (GCallback) _moserial_receive_chooser_dialog_response_gtk_dialog_response, self, 0);
	}
	return obj;
}


static void moserial_receive_chooser_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialReceiveChooserDialog * self;
	gpointer boxed;
	self = MOSERIAL_RECEIVE_CHOOSER_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_RECEIVE_CHOOSER_DIALOG_BUILDER:
		g_value_set_object (value, moserial_receive_chooser_dialog_get_builder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_receive_chooser_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialReceiveChooserDialog * self;
	self = MOSERIAL_RECEIVE_CHOOSER_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_RECEIVE_CHOOSER_DIALOG_BUILDER:
		moserial_receive_chooser_dialog_set_builder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_receive_chooser_dialog_class_init (moserialReceiveChooserDialogClass * klass) {
	moserial_receive_chooser_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialReceiveChooserDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_receive_chooser_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_receive_chooser_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_receive_chooser_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_receive_chooser_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RECEIVE_CHOOSER_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("start_transfer", MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void moserial_receive_chooser_dialog_instance_init (moserialReceiveChooserDialog * self) {
	self->priv = MOSERIAL_RECEIVE_CHOOSER_DIALOG_GET_PRIVATE (self);
}


static void moserial_receive_chooser_dialog_finalize (GObject* obj) {
	moserialReceiveChooserDialog * self;
	self = MOSERIAL_RECEIVE_CHOOSER_DIALOG (obj);
	(self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL));
	(self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL));
	(self->protocolCombo == NULL) ? NULL : (self->protocolCombo = (g_object_unref (self->protocolCombo), NULL));
	self->path = (g_free (self->path), NULL);
	G_OBJECT_CLASS (moserial_receive_chooser_dialog_parent_class)->finalize (obj);
}


GType moserial_receive_chooser_dialog_get_type (void) {
	static GType moserial_receive_chooser_dialog_type_id = 0;
	if (moserial_receive_chooser_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialReceiveChooserDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_receive_chooser_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialReceiveChooserDialog), 0, (GInstanceInitFunc) moserial_receive_chooser_dialog_instance_init, NULL };
		moserial_receive_chooser_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialReceiveChooserDialog", &g_define_type_info, 0);
	}
	return moserial_receive_chooser_dialog_type_id;
}




