/* Szwrapper.c generated by valac 0.12.0, the Vala compiler
 * generated from Szwrapper.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */
/*Class for communicating with the sz program*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define MOSERIAL_TYPE_SZWRAPPER (moserial_szwrapper_get_type ())
#define MOSERIAL_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper))
#define MOSERIAL_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))
#define MOSERIAL_IS_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_IS_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_SZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))

typedef struct _moserialSzwrapper moserialSzwrapper;
typedef struct _moserialSzwrapperClass moserialSzwrapperClass;
typedef struct _moserialSzwrapperPrivate moserialSzwrapperPrivate;

#define MOSERIAL_SZWRAPPER_TYPE_PROTOCOL (moserial_szwrapper_protocol_get_type ())

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _moserialSzwrapper {
	GObject parent_instance;
	moserialSzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialSzwrapperClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_RAW,
	MOSERIAL_SZWRAPPER_PROTOCOL_NULL
} moserialSzwrapperProtocol;

struct _moserialSzwrapperPrivate {
	moserialSzwrapperProtocol _protocol;
	moserialSerialConnection* _sc;
	GIOChannel* IOChannelInput;
	GIOChannel* IOChannelOutput;
	GIOChannel* IOChannelError;
	guint outputChannelId;
	guint errorChannelId;
	GPid pid;
	gchar* _filename;
};


static gpointer moserial_szwrapper_parent_class = NULL;

GType moserial_szwrapper_get_type (void) G_GNUC_CONST;
GType moserial_szwrapper_protocol_get_type (void) G_GNUC_CONST;
GType moserial_serial_connection_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SZWRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperPrivate))
enum  {
	MOSERIAL_SZWRAPPER_DUMMY_PROPERTY,
	MOSERIAL_SZWRAPPER_PROTOCOL,
	MOSERIAL_SZWRAPPER_SC,
	MOSERIAL_SZWRAPPER_FILENAME
};
moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename);
moserialSzwrapper* moserial_szwrapper_construct (GType object_type, moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename);
void moserial_szwrapper_writeChar (moserialSzwrapper* self, guchar byte);
static void moserial_szwrapper_shutdown (moserialSzwrapper* self);
static gboolean moserial_szwrapper_readError (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition);
gchar* mo_utils_getLastMessage (const gchar* messages);
static gboolean moserial_szwrapper_shutdown_timeout (moserialSzwrapper* self);
static gboolean _moserial_szwrapper_shutdown_timeout_gsource_func (gpointer self);
void moserial_szwrapper_transferCanceled (moserialSzwrapper* self, GObject* o);
moserialSzwrapperProtocol moserial_szwrapper_get_protocol (moserialSzwrapper* self);
moserialSerialConnection* moserial_szwrapper_get_sc (moserialSzwrapper* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
static gboolean moserial_szwrapper_readBytes (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition);
void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size);
static void moserial_szwrapper_set_protocol (moserialSzwrapper* self, moserialSzwrapperProtocol value);
static void moserial_szwrapper_set_sc (moserialSzwrapper* self, moserialSerialConnection* value);
const gchar* moserial_szwrapper_get_filename (moserialSzwrapper* self);
static void moserial_szwrapper_set_filename (moserialSzwrapper* self, const gchar* value);
static GObject * moserial_szwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _moserial_szwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static gboolean _moserial_szwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void moserial_szwrapper_finalize (GObject* obj);
static void _vala_moserial_szwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_moserial_szwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* MOSERIAL_SZWRAPPER_ProtocolStrings[4] = {"Xmodem", "Ymodem", "Zmodem", "None (straight binary)"};

GType moserial_szwrapper_protocol_get_type (void) {
	static volatile gsize moserial_szwrapper_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_szwrapper_protocol_type_id__volatile)) {
		static const GEnumValue values[] = {{MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM", "xmodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM", "ymodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM", "zmodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_RAW, "MOSERIAL_SZWRAPPER_PROTOCOL_RAW", "raw"}, {MOSERIAL_SZWRAPPER_PROTOCOL_NULL, "MOSERIAL_SZWRAPPER_PROTOCOL_NULL", "null"}, {0, NULL, NULL}};
		GType moserial_szwrapper_protocol_type_id;
		moserial_szwrapper_protocol_type_id = g_enum_register_static ("moserialSzwrapperProtocol", values);
		g_once_init_leave (&moserial_szwrapper_protocol_type_id__volatile, moserial_szwrapper_protocol_type_id);
	}
	return moserial_szwrapper_protocol_type_id__volatile;
}


moserialSzwrapper* moserial_szwrapper_construct (GType object_type, moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename) {
	moserialSzwrapper * self = NULL;
	moserialSzwrapperProtocol pro;
	pro = *protocol;
	self = (moserialSzwrapper*) g_object_new (object_type, "protocol", pro, "sc", sc, "filename", filename, NULL);
	return self;
}


moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename) {
	return moserial_szwrapper_construct (MOSERIAL_TYPE_SZWRAPPER, protocol, sc, filename);
}


void moserial_szwrapper_writeChar (moserialSzwrapper* self, guchar byte) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->running) {
		gsize bytesWritten = 0UL;
		gchar* _tmp0_ = NULL;
		gchar* b;
		gint b_length1;
		gint _b_size_;
		_tmp0_ = g_new0 (gchar, 1);
		b = _tmp0_;
		b_length1 = 1;
		_b_size_ = 1;
		b[0] = (gchar) byte;
		if (self->running) {
			gsize _tmp1_;
			g_io_channel_write_chars (self->priv->IOChannelInput, b, b_length1, &_tmp1_, &_inner_error_);
			bytesWritten = _tmp1_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch19_g_io_channel_error;
				}
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch19_g_convert_error;
				}
				b = (g_free (b), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (self->running) {
			g_io_channel_flush (self->priv->IOChannelInput, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch19_g_io_channel_error;
				}
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch19_g_convert_error;
				}
				b = (g_free (b), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally19;
		__catch19_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			moserial_szwrapper_shutdown (self);
			fprintf (stdout, "writeChar() %s\n", e->message);
			_g_error_free0 (e);
		}
		goto __finally19;
		__catch19_g_convert_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "%s\n", e->message);
			_g_error_free0 (e);
		}
		__finally19:
		if (_inner_error_ != NULL) {
			b = (g_free (b), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		b = (g_free (b), NULL);
	}
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean _moserial_szwrapper_shutdown_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = moserial_szwrapper_shutdown_timeout (self);
	return result;
}


static gboolean moserial_szwrapper_readError (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = gtk_events_pending ();
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = gdk_events_pending ();
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
		gtk_main_iteration_do (FALSE);
	}
	if (self->running) {
		gchar* _tmp3_ = NULL;
		gchar* m_buf;
		gint m_buf_length1;
		gint _m_buf_size_;
		gchar* _tmp4_;
		gchar* messages;
		gchar* _tmp5_;
		gchar* message;
		gsize bytesRead;
		gsize _tmp6_;
		gchar* _tmp14_ = NULL;
		gint _tmp15_;
		gint _tmp16_;
		_tmp3_ = g_new0 (gchar, 1000);
		m_buf = _tmp3_;
		m_buf_length1 = 1000;
		_m_buf_size_ = 1000;
		_tmp4_ = g_strdup ("");
		messages = _tmp4_;
		_tmp5_ = g_strdup ("");
		message = _tmp5_;
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			result = TRUE;
			_g_free0 (message);
			_g_free0 (messages);
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		g_io_channel_read_chars (source, m_buf, m_buf_length1, &_tmp6_, &_inner_error_);
		bytesRead = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch20_g_convert_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch20_g_io_channel_error;
			}
			_g_free0 (message);
			_g_free0 (messages);
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		goto __finally20;
		__catch20_g_convert_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "%s\n", e->message);
			_g_error_free0 (e);
		}
		goto __finally20;
		__catch20_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "readError() %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally20:
		if (_inner_error_ != NULL) {
			_g_free0 (message);
			_g_free0 (messages);
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			gint x;
			x = 0;
			{
				gboolean _tmp7_;
				_tmp7_ = TRUE;
				while (TRUE) {
					gunichar c;
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_;
					if (!_tmp7_) {
						x++;
					}
					_tmp7_ = FALSE;
					if (!(x < bytesRead)) {
						break;
					}
					c = (gunichar) m_buf[x];
					_tmp9_ = g_unichar_isprint (c);
					if (_tmp9_) {
						_tmp8_ = TRUE;
					} else {
						gboolean _tmp10_;
						_tmp10_ = g_unichar_isspace (c);
						_tmp8_ = _tmp10_;
					}
					if (_tmp8_) {
						gchar* _tmp11_ = NULL;
						gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp11_ = g_strdup_printf ("%c", (gint) m_buf[x]);
						_tmp12_ = _tmp11_;
						_tmp13_ = g_strconcat (messages, _tmp12_, NULL);
						_g_free0 (messages);
						messages = _tmp13_;
						_g_free0 (_tmp12_);
					}
				}
			}
		}
		_tmp14_ = mo_utils_getLastMessage (messages);
		_g_free0 (message);
		message = _tmp14_;
		if (!(g_strcmp0 (message, "") == 0)) {
			g_signal_emit_by_name (self, "update-status", message);
		}
		_tmp15_ = string_index_of (messages, "Transfer complete", 0);
		if (_tmp15_ >= 0) {
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, _moserial_szwrapper_shutdown_timeout_gsource_func, g_object_ref (self), g_object_unref);
		}
		_tmp16_ = string_index_of (messages, "Transfer incomplete", 0);
		if (_tmp16_ >= 0) {
			moserial_szwrapper_shutdown (self);
		}
		result = TRUE;
		_g_free0 (message);
		_g_free0 (messages);
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


void moserial_szwrapper_transferCanceled (moserialSzwrapper* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	if (self->running) {
		const gchar* _tmp0_ = NULL;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = _ ("canceled");
		g_signal_emit_by_name (self, "update-status", _tmp0_);
		if (self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM;
		}
		if (_tmp1_) {
			{
				gint x;
				x = 0;
				{
					gboolean _tmp3_;
					_tmp3_ = TRUE;
					while (TRUE) {
						if (!_tmp3_) {
							x++;
						}
						_tmp3_ = FALSE;
						if (!(x < 20)) {
							break;
						}
						if (self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM) {
							moserial_serial_connection_sendByte (self->priv->_sc, (guchar) ('X' & 037));
							moserial_szwrapper_writeChar (self, (guchar) ('X' & 037));
						} else {
							moserial_serial_connection_sendByte (self->priv->_sc, (guchar) 0x18);
						}
					}
				}
			}
		}
		if (self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_RAW;
		}
		if (_tmp4_) {
			moserial_szwrapper_shutdown (self);
		}
	}
}


static gboolean moserial_szwrapper_shutdown_timeout (moserialSzwrapper* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	moserial_szwrapper_shutdown (self);
	result = FALSE;
	return result;
}


static void moserial_szwrapper_shutdown (moserialSzwrapper* self) {
	g_return_if_fail (self != NULL);
	if (self->running) {
		self->running = FALSE;
		g_source_remove (self->priv->outputChannelId);
		g_source_remove (self->priv->errorChannelId);
		g_spawn_close_pid (self->priv->pid);
		g_signal_emit_by_name (self, "transfer-complete");
	}
}


static gboolean moserial_szwrapper_readBytes (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = gtk_events_pending ();
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = gdk_events_pending ();
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
		gtk_main_iteration_do (FALSE);
	}
	if (self->running) {
		gchar* _tmp3_ = NULL;
		gchar* m_buf;
		gint m_buf_length1;
		gint _m_buf_size_;
		gsize bytesRead;
		gsize _tmp4_;
		_tmp3_ = g_new0 (gchar, 1024);
		m_buf = _tmp3_;
		m_buf_length1 = 1024;
		_m_buf_size_ = 1024;
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			result = TRUE;
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		g_io_channel_read_chars (source, m_buf, m_buf_length1, &_tmp4_, &_inner_error_);
		bytesRead = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch21_g_convert_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch21_g_io_channel_error;
			}
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		goto __finally21;
		__catch21_g_convert_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "%s\n", e->message);
			_g_error_free0 (e);
		}
		goto __finally21;
		__catch21_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "readError() %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally21:
		if (_inner_error_ != NULL) {
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		moserial_serial_connection_sendBytes (self->priv->_sc, m_buf, m_buf_length1, bytesRead);
		result = TRUE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


moserialSzwrapperProtocol moserial_szwrapper_get_protocol (moserialSzwrapper* self) {
	moserialSzwrapperProtocol result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_protocol;
	return result;
}


static void moserial_szwrapper_set_protocol (moserialSzwrapper* self, moserialSzwrapperProtocol value) {
	g_return_if_fail (self != NULL);
	self->priv->_protocol = value;
	g_object_notify ((GObject *) self, "protocol");
}


moserialSerialConnection* moserial_szwrapper_get_sc (moserialSzwrapper* self) {
	moserialSerialConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sc;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void moserial_szwrapper_set_sc (moserialSzwrapper* self, moserialSerialConnection* value) {
	moserialSerialConnection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_sc);
	self->priv->_sc = _tmp0_;
	g_object_notify ((GObject *) self, "sc");
}


const gchar* moserial_szwrapper_get_filename (moserialSzwrapper* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
	return result;
}


static void moserial_szwrapper_set_filename (moserialSzwrapper* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp0_;
	g_object_notify ((GObject *) self, "filename");
}


static gboolean _moserial_szwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_szwrapper_readBytes (self, source, condition);
	return result;
}


static gboolean _moserial_szwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_szwrapper_readError (self, source, condition);
	return result;
}


static GObject * moserial_szwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialSzwrapper * self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (moserial_szwrapper_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_SZWRAPPER (obj);
	if (self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_filename == NULL;
	}
	if (_tmp0_) {
		self->running = FALSE;
	} else {
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		gint output = 0;
		gint _error_ = 0;
		gint input = 0;
		GPid _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		GIOChannel* _tmp23_ = NULL;
		GIOChannel* _tmp24_ = NULL;
		GIOChannel* _tmp25_ = NULL;
		guint _tmp26_;
		guint _tmp27_;
		if (self->priv->_protocol == MOSERIAL_SZWRAPPER_PROTOCOL_RAW) {
			gchar** _tmp1_ = NULL;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp1_ = g_new0 (gchar*, 2 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp1_;
			argv_length1 = 2;
			_argv_size_ = 2;
			_tmp2_ = g_strdup ("cat");
			_tmp3_ = _tmp2_;
			_g_free0 (argv[0]);
			argv[0] = _tmp3_;
			_tmp4_ = g_strdup (self->priv->_filename);
			_tmp5_ = _tmp4_;
			_g_free0 (argv[1]);
			argv[1] = _tmp5_;
		} else {
			gchar** _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp6_ = g_new0 (gchar*, 4 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp6_;
			argv_length1 = 4;
			_argv_size_ = 4;
			_tmp7_ = g_strdup ("sz");
			_tmp8_ = _tmp7_;
			_g_free0 (argv[0]);
			argv[0] = _tmp8_;
			switch (self->priv->_protocol) {
				case MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM:
				{
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp9_ = g_strdup ("--xmodem");
					_tmp10_ = _tmp9_;
					_g_free0 (argv[1]);
					argv[1] = _tmp10_;
					break;
				}
				case MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM:
				{
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp11_ = g_strdup ("--ymodem");
					_tmp12_ = _tmp11_;
					_g_free0 (argv[1]);
					argv[1] = _tmp12_;
					break;
				}
				default:
				case MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM:
				{
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp13_ = g_strdup ("--zmodem");
					_tmp14_ = _tmp13_;
					_g_free0 (argv[1]);
					argv[1] = _tmp14_;
					break;
				}
			}
			_tmp15_ = g_strdup ("-vv");
			_tmp16_ = _tmp15_;
			_g_free0 (argv[2]);
			argv[2] = _tmp16_;
			_tmp17_ = g_strdup (self->priv->_filename);
			_tmp18_ = _tmp17_;
			_g_free0 (argv[3]);
			argv[3] = _tmp18_;
		}
		g_spawn_async_with_pipes (NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp19_, &_tmp20_, &_tmp21_, &_tmp22_, &_inner_error_);
		self->priv->pid = _tmp19_;
		input = _tmp20_;
		output = _tmp21_;
		_error_ = _tmp22_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch22_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch22_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp23_ = g_io_channel_unix_new (output);
		_g_io_channel_unref0 (self->priv->IOChannelOutput);
		self->priv->IOChannelOutput = _tmp23_;
		_tmp24_ = g_io_channel_unix_new (input);
		_g_io_channel_unref0 (self->priv->IOChannelInput);
		self->priv->IOChannelInput = _tmp24_;
		_tmp25_ = g_io_channel_unix_new (_error_);
		_g_io_channel_unref0 (self->priv->IOChannelError);
		self->priv->IOChannelError = _tmp25_;
		g_io_channel_set_encoding (self->priv->IOChannelOutput, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch22_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch22_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		g_io_channel_set_flags (self->priv->IOChannelOutput, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch22_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch22_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		g_io_channel_set_encoding (self->priv->IOChannelError, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch22_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch22_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		g_io_channel_set_flags (self->priv->IOChannelError, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch22_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch22_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		g_io_channel_set_encoding (self->priv->IOChannelInput, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch22_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch22_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp26_ = g_io_add_watch (self->priv->IOChannelOutput, G_IO_IN, _moserial_szwrapper_readBytes_gio_func, self);
		self->priv->outputChannelId = _tmp26_;
		_tmp27_ = g_io_add_watch (self->priv->IOChannelError, G_IO_IN, _moserial_szwrapper_readError_gio_func, self);
		self->priv->errorChannelId = _tmp27_;
		self->running = TRUE;
		goto __finally22;
		__catch22_g_spawn_error:
		{
			GError * e;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			GtkMessageDialog* _tmp30_ = NULL;
			GtkMessageDialog* _tmp31_;
			GtkMessageDialog* errorDialog;
			e = _inner_error_;
			_inner_error_ = NULL;
			self->running = FALSE;
			fprintf (stdout, "spawn error: %s\n", e->message);
			_tmp28_ = g_strdup_printf ("%s", e->message);
			_tmp29_ = _tmp28_;
			_tmp30_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp29_);
			_tmp31_ = g_object_ref_sink (_tmp30_);
			_g_free0 (_tmp29_);
			errorDialog = _tmp31_;
			gtk_dialog_run ((GtkDialog*) errorDialog);
			gtk_widget_destroy ((GtkWidget*) errorDialog);
			_g_object_unref0 (errorDialog);
			_g_error_free0 (e);
		}
		goto __finally22;
		__catch22_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "readError() %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally22:
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	return obj;
}


static void moserial_szwrapper_class_init (moserialSzwrapperClass * klass) {
	moserial_szwrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSzwrapperPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_moserial_szwrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_moserial_szwrapper_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_szwrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_szwrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_PROTOCOL, g_param_spec_enum ("protocol", "protocol", "protocol", MOSERIAL_SZWRAPPER_TYPE_PROTOCOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_SC, g_param_spec_object ("sc", "sc", "sc", MOSERIAL_TYPE_SERIAL_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("transfer_complete", MOSERIAL_TYPE_SZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("update_status", MOSERIAL_TYPE_SZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void moserial_szwrapper_instance_init (moserialSzwrapper * self) {
	self->priv = MOSERIAL_SZWRAPPER_GET_PRIVATE (self);
	self->running = FALSE;
}


static void moserial_szwrapper_finalize (GObject* obj) {
	moserialSzwrapper * self;
	self = MOSERIAL_SZWRAPPER (obj);
	_g_object_unref0 (self->priv->_sc);
	_g_io_channel_unref0 (self->priv->IOChannelInput);
	_g_io_channel_unref0 (self->priv->IOChannelOutput);
	_g_io_channel_unref0 (self->priv->IOChannelError);
	_g_free0 (self->priv->_filename);
	G_OBJECT_CLASS (moserial_szwrapper_parent_class)->finalize (obj);
}


GType moserial_szwrapper_get_type (void) {
	static volatile gsize moserial_szwrapper_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_szwrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSzwrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_szwrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSzwrapper), 0, (GInstanceInitFunc) moserial_szwrapper_instance_init, NULL };
		GType moserial_szwrapper_type_id;
		moserial_szwrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSzwrapper", &g_define_type_info, 0);
		g_once_init_leave (&moserial_szwrapper_type_id__volatile, moserial_szwrapper_type_id);
	}
	return moserial_szwrapper_type_id__volatile;
}


static void _vala_moserial_szwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSzwrapper * self;
	self = MOSERIAL_SZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_SZWRAPPER_PROTOCOL:
		g_value_set_enum (value, moserial_szwrapper_get_protocol (self));
		break;
		case MOSERIAL_SZWRAPPER_SC:
		g_value_set_object (value, moserial_szwrapper_get_sc (self));
		break;
		case MOSERIAL_SZWRAPPER_FILENAME:
		g_value_set_string (value, moserial_szwrapper_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_moserial_szwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSzwrapper * self;
	self = MOSERIAL_SZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_SZWRAPPER_PROTOCOL:
		moserial_szwrapper_set_protocol (self, g_value_get_enum (value));
		break;
		case MOSERIAL_SZWRAPPER_SC:
		moserial_szwrapper_set_sc (self, g_value_get_object (value));
		break;
		case MOSERIAL_SZWRAPPER_FILENAME:
		moserial_szwrapper_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



