/*
 * Clutter.
 *
 * An OpenGL based 'interactive canvas' library.
 *
 * Copyright (C) 2010  Intel Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Emmanuele Bassi <ebassi@linux.intel.com>
 */

#ifndef __CLUTTER_SHADER_EFFECT_H__
#define __CLUTTER_SHADER_EFFECT_H__

#if !defined(__CLUTTER_H_INSIDE__) && !defined(CLUTTER_COMPILATION)
#error "Only <clutter/clutter.h> can be included directly."
#endif

#include <clutter/clutter-offscreen-effect.h>

G_BEGIN_DECLS

#define CLUTTER_TYPE_SHADER_EFFECT              (clutter_shader_effect_get_type ())
#define CLUTTER_SHADER_EFFECT(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLUTTER_TYPE_SHADER_EFFECT, ClutterShaderEffect))
#define CLUTTER_IS_SHADER_EFFECT(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLUTTER_TYPE_SHADER_EFFECT))
#define CLUTTER_SHADER_EFFECT_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), CLUTTER_TYPE_SHADER_EFFECT, ClutterShaderEffectClass))
#define CLUTTER_IS_SHADER_EFFECT_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), CLUTTER_TYPE_SHADER_EFFECT))
#define CLUTTER_SHADER_EFFECT_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), CLUTTER_TYPE_SHADER_EFFECT, ClutterShaderEffectClass))

typedef struct _ClutterShaderEffect             ClutterShaderEffect;
typedef struct _ClutterShaderEffectPrivate      ClutterShaderEffectPrivate;
typedef struct _ClutterShaderEffectClass        ClutterShaderEffectClass;

struct _ClutterShaderEffect
{
  /*< private >*/
  ClutterOffscreenEffect parent_instance;

  ClutterShaderEffectPrivate *priv;
};

/**
 * ClutterShaderEffectClass:
 * @get_static_shader_source: Returns the GLSL source code to use for
 *  instances of this shader effect. Note that this function is only
 *  called once per subclass of #ClutterShaderEffect regardless of how
 *  many instances are used. It is expected that subclasses will return
 *  a copy of a static string from this function.
 *
 * The #ClutterShaderEffectClass structure contains
 * only private data
 */
struct _ClutterShaderEffectClass
{
  /*< private >*/
  ClutterOffscreenEffectClass parent_class;

  /*< public >*/
  gchar * (* get_static_shader_source) (ClutterShaderEffect *effect);
};

CLUTTER_EXPORT
GType clutter_shader_effect_get_type (void) G_GNUC_CONST;

CLUTTER_EXPORT
ClutterEffect * clutter_shader_effect_new               (ClutterShaderType    shader_type);

CLUTTER_EXPORT
gboolean        clutter_shader_effect_set_shader_source (ClutterShaderEffect *effect,
                                                         const gchar         *source);

CLUTTER_EXPORT
void            clutter_shader_effect_set_uniform       (ClutterShaderEffect *effect,
                                                         const gchar         *name,
                                                         GType                gtype,
                                                         gsize                n_values,
                                                         ...);
CLUTTER_EXPORT
void            clutter_shader_effect_set_uniform_value (ClutterShaderEffect *effect,
                                                         const gchar         *name,
                                                         const GValue        *value);

CLUTTER_EXPORT
CoglHandle      clutter_shader_effect_get_shader        (ClutterShaderEffect *effect);
CLUTTER_EXPORT
CoglHandle      clutter_shader_effect_get_program       (ClutterShaderEffect *effect);

G_END_DECLS

#endif /* __CLUTTER_SHADER_EFFECT_H__ */
