# -*- coding: utf-8 -*-

# Copyright (C) 2004-2007 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

from gettext import gettext as _

import gtk

import GUI
from ontv import NAME

class ProgramDialog:
    def __init__(self, program):
        self.__get_widgets()
        self.__connect_widgets()
        self.name_label.set_text(program.title)
        self.channel_label.set_text(program.channel.name)
        self.description_label.set_text(program.description)
        self.air_time_label.set_text(("%s-%s\n%s") %
                                      (program.start_time, program.stop_time,
                                       program.date))

        self.dialog.set_title(_("Details about %s") % program.title)
        if program.channel.logo:
            self.channel_image.set_from_pixbuf(program.channel.logo)
        else:
            self.channel_image.set_from_icon_name(NAME.lower(),
                                                  gtk.ICON_SIZE_DIALOG)

    def __get_widgets(self):
        xml = gtk.glade.XML(GUI.glade_file, domain=NAME.lower())

        self.dialog = xml.get_widget("program_dialog")

        self.name_label = xml.get_widget("name_label")
        self.channel_image = xml.get_widget("channel_image")
        self.channel_label = xml.get_widget("channel_label")
        self.description_label = xml.get_widget("description_label")
        self.air_time_label = xml.get_widget("air_time_label")

    def __connect_widgets(self):
        self.dialog.connect("delete-event", self.__dialog_delete)
        self.dialog.connect("response", self.__dialog_response)

    def __dialog_response(self, dialog, response):
        self.dialog.destroy()

    def __dialog_delete(self, dialog, event):
        return True

    def show(self):
        self.dialog.show()

# vim: set sw=4 et sts=4 tw=79 fo+=l:
