# -*- coding: utf-8 -*-

# Copyright (C) 2004-2007 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

from gettext import gettext as _

import gtk

import GUI

from ontv import NAME

class ChannelDialog:
    def __init__(self, channel, pd):
        self.channel = channel
        self.pd = pd
        self.__get_widgets()

        if self.channel.logo_file != "":
            self.logo_iconentry.set_filename(self.channel.logo_file)

        self.__connect_widgets()
        self.channel_label.set_text(channel.name)

        self.dialog.set_title(_("Properties for channel %s") % channel.name)

    def __get_widgets(self):
        xml = gtk.glade.XML(GUI.glade_file, domain=NAME.lower())

        self.dialog = xml.get_widget("channel_dialog")

        self.channel_label = xml.get_widget("channel_label2")
        self.logo_iconentry = xml.get_widget("logo_iconentry")

    def __connect_widgets(self):
        self.dialog.connect("delete-event", self.__dialog_delete)
        self.dialog.connect("response", self.__dialog_response)
        self.logo_iconentry.connect("changed", self.__logo_iconentry_changed)

    def __dialog_response(self, dialog, response):
        dialog.destroy()

    def __dialog_delete(self, dialog, event):
        return True

    def __logo_iconentry_changed(self, logo_iconentry):
        icon_file = logo_iconentry.get_filename()
        if not icon_file:
            self.channel.logo_file = ""
            self.channel.logo = self.channel.logo_small = None
        else:
            self.channel.logo_file = icon_file
            self.channel.set_logo(self.channel.logo_file)
        self.channel.custom_logo = True

        logo_column = self.pd.channels_treeview.get_column(1)
        logo_column.queue_resize()
        self.pd.pw.update()
        self.pd.listings.save()

    def show(self):
        self.dialog.show()

# vim: set sw=4 et sts=4 tw=79 fo+=l:
