# Orca
#
# Copyright 2005-2008 Sun Microsystems Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., Franklin Street, Fifth Floor,
# Boston MA  02110-1301 USA.

"""Custom script for gdmlogin - this makes sure the focused item is spoken
when Orca starts."""

__id__        = "$Id: gdmlogin.py 3882 2008-05-07 18:22:10Z richb $"
__version__   = "$Revision: 3882 $"
__date__      = "$Date: 2008-05-07 14:22:10 -0400 (Wed, 07 May 2008) $"
__copyright__ = "Copyright (c) 2005-2008 Sun Microsystems Inc."
__license__   = "LGPL"

import orca.default as default
import orca.orca as orca
import orca.settings as settings

########################################################################
#                                                                      #
# The gdmlogin script class.                                           #
#                                                                      #
########################################################################

class Script(default.Script):

    def __init__(self, app):
        """Creates a new script for the given application.

        Arguments:
        - app: the application to create a script for.
        """

        default.Script.__init__(self, app)

    def onWindowActivated(self, event):
        # Sets the context to the top level window first, so we can
        # get information about it the window we just moved to.
        #
        orca.setLocusOfFocus(event, event.source)

        # Now we find the focused object and set the locus of focus to it.
        #
        obj = self.findFocusedObject(self.app)
        if obj:
            orca.setLocusOfFocus(event, obj)
        else:
            default.Script.onWindowActivated(self, event)

    def activate(self):
        """Called when this script is activated."""
        # We disable key echo because gdm reuses the username text
        # area for the password area and doesn't change the role 
        # from 'text' to 'password' when doing so.  As a result,
        # key echo will echo the keys typed when entering a password.
        # See bug #517387.
        #
        settings.enableKeyEcho = False
