#include <glib.h>

#include <pan/base/acache.h>
#include <pan/base/pan-i18n.h>
#include <pan/base/pan-glib-extensions.h>
#include <pan/base/base-prefs.h>

gchar * data_dir = NULL;
gchar * temp_dir = NULL;
gchar * download_dir = NULL;
gchar * default_incoming_name_real;
gchar * default_incoming_name_addr;
gint acache_max_megs = 10;
gboolean acache_flush_on_exit = FALSE;
gboolean break_thread_when_subject_changes = FALSE;


void
base_prefs_init (const gchar    * new_data_dir,
                 const gchar    * new_temp_dir,
                 const gchar    * new_download_dir,
                 gint             new_acache_max_megs,
                 gboolean         new_acache_flush_on_exit,
                 gboolean         break_thread)
{
	replace_gstr (&data_dir, g_strdup(new_data_dir));
	replace_gstr (&temp_dir, g_strdup(new_temp_dir));
	replace_gstr (&download_dir, g_strdup(new_download_dir));
	break_thread_when_subject_changes = break_thread;

	acache_max_megs = new_acache_max_megs;
	acache_flush_on_exit = new_acache_flush_on_exit;
	acache_init ();

	default_incoming_name_real = _("Unknown");
	default_incoming_name_addr = _("unknown@spammesenseless.net");
}
