/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __GNKSA_H__
#define __GNKSA_H__

#include <glib.h>
#include <time.h>

enum
{
	/* success/undefined error */
	GNKSA_OK			= 0,
	GNKSA_INTERNAL_ERROR		= 1,

	/* general syntax */
	GNKSA_LANGLE_MISSING		= 100,
	GNKSA_RANGLE_MISSING		= 101,
	GNKSA_LPAREN_MISSING		= 102,
	GNKSA_RPAREN_MISSING		= 103,
	GNKSA_ATSIGN_MISSING		= 104,

	/* FQDN checks */
	GNKSA_SINGLE_DOMAIN		= 200,
	GNKSA_INVALID_DOMAIN		= 201,
	GNKSA_ILLEGAL_DOMAIN		= 202,
	GNKSA_UNKNOWN_DOMAIN		= 203,
	GNKSA_INVALID_FQDN_CHAR		= 204,
	GNKSA_ZERO_LENGTH_LABEL		= 205,
	GNKSA_ILLEGAL_LABEL_LENGTH	= 206,
	GNKSA_ILLEGAL_LABEL_HYPHEN	= 207,
	GNKSA_ILLEGAL_LABEL_BEGNUM	= 208,
	GNKSA_BAD_DOMAIN_LITERAL	= 209,
	GNKSA_LOCAL_DOMAIN_LITERAL	= 210,
	GNKSA_RBRACKET_MISSING		= 211,

	/* localpart checks */
	GNKSA_LOCALPART_MISSING		= 300,
	GNKSA_INVALID_LOCALPART		= 301,
	GNKSA_ZERO_LENGTH_LOCAL_WORD	= 302,

	/* realname checks */
	GNKSA_ILLEGAL_UNQUOTED_CHAR	= 400,
	GNKSA_ILLEGAL_QUOTED_CHAR	= 401,
	GNKSA_ILLEGAL_ENCODED_CHAR	= 402,
	GNKSA_BAD_ENCODE_SYNTAX		= 403,
	GNKSA_ILLEGAL_PAREN_PHRASE	= 404,
	GNKSA_ILLEGAL_PAREN_CHAR	= 405,
	GNKSA_INVALID_REALNAME		= 406,
	GNKSA_ILLEGAL_PLAIN_PHRASE	= 407,

	/* address types */
	GNKSA_ADDRTYPE_ROUTE		= 0,
	GNKSA_ADDRTYPE_OLDSTYLE		= 1
};

gint          gnksa_check_from                            (const gchar    * from,
                                                           gboolean         strict);

gint          gnksa_do_check_from                         (const gchar    * from,
                                                           gchar         ** alloc_address,
                                                           gchar         ** alloc_realname,
                                                           gboolean         strict);

void          gnksa_strip_realname                        (gchar          * realname);

GPtrArray*    gnksa_split_addresses                       (const gchar    * from);

gchar*        gnksa_trim_references_to_len                (const gchar    * refs,
                                                           gint             cutoff);

gchar*        gnksa_generate_references                   (const gchar    * references,
                                                           const gchar    * message_id);

gchar*        gnksa_generate_message_id_from_email_addr   (const gchar * from);

gchar*        gnksa_generate_message_id                   (const gchar    * domain_name);

gchar*        rfc822_date_generate                        (time_t           secs);
 
#endif
