#include <pthread.h>
#include <pan/base/argset.h>

ArgSet*
argset_new (void) {
	ArgSet * argset = g_new0 (ArgSet, 1);
	argset->args = g_ptr_array_new ();
	return argset;
}
ArgSet* argset_new1 (gpointer p1)
{
	ArgSet * argset = argset_new ();
	g_ptr_array_add (argset->args, p1);
	return argset;
}
ArgSet*
argset_new2 (gpointer p1, gpointer p2) {
	ArgSet * argset = argset_new1 (p1);
	g_ptr_array_add (argset->args, p2);
	return argset;
}
ArgSet*
argset_new3 (gpointer p1, gpointer p2, gpointer p3) {
	ArgSet * argset = argset_new2 (p1, p2);
	g_ptr_array_add (argset->args, p3);
	return argset;
}
ArgSet*
argset_new4 (gpointer p1, gpointer p2, gpointer p3, gpointer p4) {
	ArgSet * argset = argset_new3 (p1, p2, p3);
	g_ptr_array_add (argset->args, p4);
	return argset;
}
ArgSet*
argset_new5 (gpointer p1, gpointer p2, gpointer p3, gpointer p4, gpointer p5) {
	ArgSet * argset = argset_new4 (p1, p2, p3, p4);
	g_ptr_array_add (argset->args, p5);
	return argset;
}


gpointer
argset_get (ArgSet* argset, gint index) {
	g_return_val_if_fail (argset!=NULL, NULL);
	g_return_val_if_fail (argset->args!=NULL, NULL);
	g_return_val_if_fail (index>=0, NULL);
	g_return_val_if_fail (index<argset->args->len, NULL);
	return g_ptr_array_index (argset->args, index);
}

void
argset_add (ArgSet* argset, gpointer add) {
	g_return_if_fail (argset!=NULL);
	g_return_if_fail (argset->args!=NULL);
	g_ptr_array_add (argset->args, add);
}

void
argset_free (ArgSet * argset) {
	g_return_if_fail (argset!=NULL);
	g_return_if_fail (argset->args!=NULL);
	g_ptr_array_free (argset->args, TRUE);
	g_free (argset);
}

void
run_in_worker_thread (WorkerFunc func, gpointer arg)
{
	pthread_t thread;
	pthread_create (&thread, NULL, func, arg);
	pthread_detach (thread);
}
