/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __STATUS_ITEM_VIEW__H__
#define __STATUS_ITEM_VIEW__H__

#include <gtk/gtkvbox.h>

#include <pan/base/status-item.h>

#define TYPE_STATUS_ITEM_VIEW (status_item_view_get_type())
#define STATUS_ITEM_VIEW(obj) (GTK_CHECK_CAST ((obj), TYPE_STATUS_ITEM_VIEW, StatusItemView))
#define STATUS_ITEM_VIEW_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ITEM_VIEW, StatusItemView))
#define IS_STATUS_ITEM_VIEW(obj) (GTK_CHECK_TYPE ((obj), TYPE_STATUS_ITEM_VIEW))
#define IS_STATUS_ITEM_VIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ITEM_VIEW))

typedef struct _StatusItemView           StatusItemView;
typedef struct _StatusItemViewClass      StatusItemViewClass;

struct _StatusItemView
{
	/* parente class */
	GtkVBox vbox;

	/* private fields */  
	guint signal_id_progress_set_percent;
	guint signal_id_status;
	guint signal_id_error;
	GString * last_status;
	StatusItem * item;
	GtkWidget * progress;
	GtkWidget * eventbox;
};

struct _StatusItemViewClass
{
	GtkVBoxClass parent_class;
};


/* public */

GtkType       status_item_view_get_type            (void);

GtkWidget*    status_item_view_new                 (void);

void          status_item_view_set_item_nolock     (StatusItemView  *view,
                                                    StatusItem      *item);


#endif /* __STATUS_ITEM_VIEW__H__ */
