/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ARTICLE_LIST_H__
#define __ARTICLE_LIST_H__

#include <gdk/gdk.h>
#include <gtk/gtkstyle.h>
#include <gtk/gtkctree.h>

#include "article.h"
#include "group.h"
#include "pan-callback.h"
#include "status-item.h"

extern GdkColor read_color;
extern GdkColor unread_color;
extern GdkColor new_color;
extern GdkColor killfile_color;
extern GdkColor watched_color;

extern GtkStyle *unread_style;
extern GtkStyle *read_style;
extern GtkStyle *new_style;
extern GtkStyle *killfile_style;
extern GtkStyle *watched_style;

/****
*****  CALLBACKS
****/

/**
 * called whenever the article tree's active state filter changes.
 *
 * @param call_object the article ctree
 * @param call_arg an unsigned int of the state filter bitfields
 */
extern PanCallback* articlelist_state_filter_changed;

/**
 * called whenever the article tree's active group changes.
 *
 * @param call_object the article ctree
 * @param call_arg the new active group
 */
extern PanCallback* articlelist_group_changed;

/**
 * called whenever the article tree's sorting changes.
 *
 * @param call_object the article ctree
 * @param call_arg a GINT_TO_POINTER of the new sort type.
 */
extern PanCallback* articlelist_sort_changed;

/**
 * called whenever the article tree's threaded state changes.
 *
 * @param call_object the article ctree
 * @param call_arg NULL if threading is off, non-NULL if threading is on
 */
extern PanCallback* articlelist_thread_changed;

/**
 * called whenever the article tree's selection state changes.
 *
 * @param call_object the article ctree
 * @param call_arg article of the selected article, or NULL if none
 */
extern PanCallback* articlelist_selection_changed;

/****
***** 
****/

/**
 * This pokes any given flag in the current state filter,
 * saves the state to disk,
 * and fires off the articlelist_state_filter_changed callbacks.
 */
void articlelist_poke_state_filter(guint flag, gboolean on);




/**
***
***
***
***
**/


/**
***  State Info
**/

Group* articlelist_get_group (void);

void articlelist_set_sort_type (int sort_type);

void articlelist_set_threaded (gboolean threaded_on);

void articlelist_refresh (StatusItem*);

GtkCTreeNode* articlelist_get_selected_node (void);

Article* articlelist_get_selected_article (void);

GPtrArray* articlelist_get_selected_articles (void);


/**
***  Stepping Through the Articles
**/

void articlelist_set_selected_nodes (GtkCTreeNode**, int qty);

GtkCTreeNode* articlelist_node_next (GtkCTreeNode*, gboolean sibling_only);

GtkCTreeNode* articlelist_node_prev (GtkCTreeNode*, gboolean sibling_only);

void articlelist_skip_to_message_id (const gchar * message_id);

void articlelist_view_message_id (const gchar * message_id);

void articlelist_view_prev (void);

void articlelist_view_next (void);

void articlelist_view_next_unread (void);

void articlelist_view_next_unread_body (void);

void articlelist_skip_to_prev (void);

void articlelist_skip_to_next (void);

void articlelist_skip_to_next_unread (void);

void articlelist_skip_to_next_unread_body (void);

void articlelist_selected_read_body (void);

void articlelist_selected_read_body_in_new_window (void);

void articlelist_skip_to_next_thread (void);

void articlelist_skip_to_prev_thread (void);




void articlelist_read_prev_article (void);

void articlelist_read_prev_unread_article (void);

void articlelist_read_prev_thread (void);

void articlelist_read_parent_article (void);

void articlelist_read_child_article (void);

void articlelist_reset_colors (void);

/**
***  Contents
**/

void articlelist_set_group (Group*);

void articlelist_set_group_thread (Group*);

void articlelist_reload (void);

void articlelist_update_node (const Article* article);

/**
***  Perform Operations on Articles
**/

void articlelist_expand_all_threads (void);

void articlelist_collapse_all_threads (void);

void articlelist_select_all (void);

void articlelist_selected_decode (void);

void articlelist_selected_decode_as (void);

void articlelist_selected_delete (void);

void articlelist_selected_delete_thread (void);

void articlelist_selected_copy_to_folder (void);

void articlelist_selected_copy_to_folder_deep (void);

void articlelist_selected_edit (void);

void articlelist_selected_cancel (void);

void articlelist_selected_supersede (void);

void articlelist_selected_move_to_folder (void);

void articlelist_selected_move_to_folder_deep (void);

void articlelist_selected_mark_read (void);

void articlelist_selected_mark_read_deep (void);

void articlelist_selected_mark_read_thread (void);

void articlelist_selected_mark_unread (void);

void articlelist_selected_mark_unread_deep (void);

void articlelist_selected_mark_unread_thread (void);

void articlelist_selected_open (void);

void articlelist_selected_thread_download (void);

void articlelist_selected_thread_ignore (void);

void articlelist_selected_thread_watch (void);

void articlelist_bozoize_author (void);

void articlelist_all_mark_read (void);

void articlelist_all_mark_unread (void);

void articlelist_all_download (void);

void articlelist_all_delete (void);

void articlelist_selected_download (void);

void articlelist_selected_flag_for_dl (void);

void articlelist_selected_flag_for_dl_deep (void);

void articlelist_selected_unflag_for_dl (void);

void articlelist_selected_unflag_for_dl_deep (void);

void articlelist_download_flagged_bodies (void);

/**
***  Misc
**/

GtkWidget* create_articlelist_ctree (void);

void articlelist_article_read_changed (const Article*);

void search_deja (void);

#endif /* __ARTICLE_LIST_H__ */
