

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "rules_callbacks.h"
#include "rules_interface.h"
#include "support.h"

#include "../bozo.h"
#include "../util.h"

#include <gnome.h>

static gboolean
get_selected_bozo (GtkCList     * clist,
                   int          * setme_row,
                   gchar       ** setme_const_real,
                   gchar       ** setme_const_mail)
{
	gboolean retval = FALSE;
	GList * l = clist->selection;
	if (l != NULL)
	{
		const int row = GPOINTER_TO_INT(l->data);

		if (setme_row != NULL)
		{
			*setme_row = row;
			retval = TRUE;
		}
		if (setme_const_real != NULL)
		{
			gtk_clist_get_text (clist, row, 0, setme_const_real);
			retval = TRUE;
		}
		if (setme_const_mail != NULL)
		{
			gtk_clist_get_text (clist, row, 1, setme_const_mail);
			retval = TRUE;
		}
	}

	return retval;
}

void
on_bozo_dialog_realize                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
	GtkCList * clist = GTK_CLIST(lookup_widget (widget, "bozo_clist"));
	GPtrArray * a = bozo_get_bozos ();
	guint i;

	/* not yet settable through glade */
	gtk_clist_set_sort_column (clist, 0);
	gtk_clist_set_auto_sort (clist, TRUE);

	/* add the bozos to the clist */
	for (i=0; i!=a->len; ++i)
	{
		int j;
		Bozo * bozo = (Bozo*) g_ptr_array_index (a, i);
		gchar * cols[2] = { bozo->real, bozo->address };
		for (j=0; j<2; ++j)
			if (cols[j] == NULL) cols[j] = "";
		gtk_clist_insert (clist, -1, cols);
	}

	/* cleanup */
	g_ptr_array_free (a, TRUE);
}


/**
***  Add a bozo
**/

void
on_bozo_create_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget * dialog;
	GtkWindow * win;

	pan_lock ();
	dialog = create_edit_bozo_dialog ();
	gtk_object_set_data (GTK_OBJECT(dialog), "mode", "new");
	gtk_object_set_data (GTK_OBJECT(dialog), "clist",
	                     lookup_widget(GTK_WIDGET(button),"bozo_clist"));
	win = GTK_WINDOW(lookup_widget(GTK_WIDGET(button),"bozo_dialog"));
	gnome_dialog_set_parent (GNOME_DIALOG(dialog), win);
	gtk_widget_show_all (dialog);
	pan_unlock ();
}
//_("Add Bozo in the form\n\"J. Random Bozo\" <bozo@spammesensless.net>"),

/**
***  Edit a bozo
**/

static void
edit_selected_bozo (GtkCList * clist)
{
	gchar * bozo_real_const = NULL;
	gchar * bozo_mail_const = NULL;

	if (get_selected_bozo (clist, NULL, &bozo_real_const, &bozo_mail_const))
	{
		GtkWidget * dialog;
		GtkWidget * w;

		pan_lock ();
		dialog = create_edit_bozo_dialog ();
		gtk_object_set_data (GTK_OBJECT(dialog), "mode", "edit");
		gtk_object_set_data (GTK_OBJECT(dialog), "clist", clist);
		w = lookup_widget (dialog, "real_name_entry");
		gtk_entry_set_text (GTK_ENTRY(w), bozo_real_const);
		w = lookup_widget (dialog, "address_entry");
		gtk_entry_set_text (GTK_ENTRY(w), bozo_mail_const);

		w = lookup_widget (GTK_WIDGET(clist),"bozo_dialog");
		gnome_dialog_set_parent (GNOME_DIALOG(dialog), GTK_WINDOW(w));
		gtk_widget_show_all (dialog);
	}
}

void
on_bozo_edit_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	edit_selected_bozo (GTK_CLIST(
		lookup_widget (GTK_WIDGET(button), "bozo_clist")));
}

void
on_bozo_clist_select_row               (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
					GdkEvent        *event,
					gpointer         user_data)
{
        GdkEventButton * bevent = (GdkEventButton *)event;
	if (bevent!=NULL
		&& bevent->button==1
		&& bevent->type==GDK_2BUTTON_PRESS)
			edit_selected_bozo (clist);

}


/**
***  Delete a bozo
**/

void
on_bozo_delete_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget * widget = GTK_WIDGET(button);
	GtkCList * clist = GTK_CLIST(lookup_widget (widget, "bozo_clist"));
	gint row = -1;
	get_selected_bozo (clist, &row, NULL, NULL);
	if (row != -1)
		gtk_clist_remove (clist, row);
}


/**
***  Close Dialog
**/

void
on_bozo_dialog_clicked                 (GnomeDialog     *gnomedialog,
                                        gint             button,
                                        gpointer         user_data)
{
	GtkWidget * widget = GTK_WIDGET(gnomedialog);
	GtkCList * clist = GTK_CLIST(lookup_widget(widget,"bozo_clist"));

	if (button==0) /* ok */
	{
		gint row;

		/* repopulate the bozo list from the UI */
		bozo_clear ();
		for (row=0; row<clist->rows; ++row)
		{
			gchar * addr_const = NULL;
			gchar * real_const = NULL;
			gtk_clist_get_text (clist, row, 0, &real_const);
			gtk_clist_get_text (clist, row, 1, &addr_const);
			bozo_add (addr_const, real_const);
		}
	}

	gnome_dialog_close (gnomedialog);
}

gint
on_bozo_dialog_close                   (GnomeDialog     *gnomedialog,
                                        gpointer         user_data)
{
	return 0;
}

/*****
******  EDIT BOZO DIALOG
*****/

void
on_edit_bozo_dialog_clicked            (GnomeDialog     *dialog,
                                        gint             arg1,
                                        gpointer         user_data)
{
	const gchar * mode = (const gchar*) gtk_object_get_data (GTK_OBJECT(dialog), "mode");
	GtkCList * clist = GTK_CLIST(gtk_object_get_data (GTK_OBJECT(dialog), "clist"));
	GtkWidget * w;
	const gchar * bozo_real;
	const gchar * bozo_mail;

	/* get the new information */
	w = lookup_widget (GTK_WIDGET(dialog), "real_name_entry");
	bozo_real = gtk_entry_get_text (GTK_ENTRY(w));
	w = lookup_widget (GTK_WIDGET(dialog), "address_entry");
	bozo_mail = gtk_entry_get_text (GTK_ENTRY(w));

	pan_lock ();
	if (!pan_strcmp (mode, "new"))
	{
		const gchar * cols[2] = {bozo_real, bozo_mail};
		gtk_clist_insert (clist, -1, (gchar**)cols);
	}
	else if (!pan_strcmp (mode, "edit") && clist->selection!=NULL)
	{
		const gint sel_row = GPOINTER_TO_INT(clist->selection->data);
		gtk_clist_set_text (clist, sel_row, 0, bozo_real);
		gtk_clist_set_text (clist, sel_row, 1, bozo_mail);
	}
	else pan_warn_if_reached ();
	pan_unlock ();

	/* close the dialog */
	gnome_dialog_close (dialog);
}

gint
on_edit_bozo_dialog_close              (GnomeDialog     *gnomedialog,
                                        gpointer         user_data)
{
	return FALSE;
}
