/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * dialog-about.c: About dialog
 */

#include <config.h>
#include <gnome.h>
#include "dialogs.h"
#include "pan-about.h"


/**
 * dialog_about:
 *
 * About window to display program information, version number, and
 * copyright.
 **/
void
dialog_about (GtkWidget * window)
{
	gchar * pch;
	GtkWidget * w;
	PanAbout * a;

	static GtkWidget * about = NULL;

	w = pan_about_new ("Pan",
	                   VERSION,
	                   _("A newsreader for GNOME"),
	                   _("Copyright (C) 1999-2001, Pan Development Team"),
	                   PAN_ABOUT_LICENSE_GPL,
	                   "http://pan.rebelbase.com/");

	a = PAN_ABOUT(w);
	pan_about_add_author (a, "Charles Kerr", _("Lead Programmer"), "charles@rebelbase.com");
	pan_about_add_author (a, "Matt Eagleson", _("Programmer & Project Originator"), "e.Messiah@superpimp.org");
	pan_about_add_author (a, "Tov are Jacobsen", _("Translations & PR"), "tovj@stud.ntnu.no");
	pan_about_add_author (a, "Jason Leach", _("Programmer, 0.6 - 0.7"), "elerium@superpimp.org");

	pch = g_strdup_printf (_("Many thanks to the following people, whose contributions are\nexamples of why Open Source software development is so enjoyable.\n\nPan %s Suggestions and Testing\n%s\n\nIf you should have been in this list but you're not,\nsend us mail and we'll put you in the next time around."),
VERSION, "\n\
	James Amundson\n\
	Adam Bailey\n\
	Nerijus Baliunas\n\
	Sandor Barany\n\
	Cav\n\
	David Chambers\n	Jacob Ils Christensen\n\
	Chuck\n	Phil Chung\n\
	Martin Cooper\n\
	Martin Cosgrave\n\
	Aaron Optimizer Digulla\n\
	CedricD\n\
	Arjan Drieman\n\
	Frank E\n\
	Ben Elliston\n\
	Benjamin Geer\n\
	Ken Geis\n\
	Himanshu J. Gohel\n	Ronny Haryanto\n\
	Jim Henderson\n\
	William Hester\n\
	Dave Hill\n\
	Adam Huffman\n\
	Alex Jacques\n\
	Craig Jones\n\
	Markus Kalb\n\
	Czako Krisztian\n\
	Kevin D. Knerr, Sr.\n\
	Christophe Lambin\n\
	Francesco Lamonica\n\
	John J. LeMay Jr.\n\
	Jeff Lightfoot\n\
	Johnny Ljunggren\n\
	Steven Lusk\n\
	Eric Stephen Macauley\n\
	Perry Melange\n\
	Deryl Mack\n\
	Pierre Maziere\n\
	Stephen Monteith\n\
	Sven Neuhaus\n\
	Leo Papandreou\n\
	Gediminas Paulauskas\n\
	Phil Pennock\n\
	NeuraL RevengE\n\
	Jan Schaumann\n\
	Thomas Schnhoff\n\
	Christian Spener\n\
	Brian Stafford\n\
	Ed Stoudenmire\n\
	Tony\n\
	Ihar Viarheichyk\n\
	Andy Wallace\n\
	Owen Williams\n\
	David Walker");
	pan_about_add_text (a, _("Thanks to"), pch);
	g_free (pch);

	gtk_signal_connect (GTK_OBJECT(w), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed),
			    &about);

	if (window != NULL)
		gnome_dialog_set_parent (GNOME_DIALOG(w),
					 GTK_WINDOW (window));

	gtk_widget_show (w);
}
