/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/* TODO:
 * [ ] ability to choose logging options (downloaded files/connections/group
 *     updates)
 * [ ] ability to limit max log size
 * [ ] colored log entries
 * [ ] log viewer editing options (remove selected...etc)
 * [ ] View->Status Bar toggle
 */

#include <config.h>

#include <glib.h>
#include <gtk/gtk.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>
#include <libgnomeui/gnome-app.h>
#include <libgnomeui/gnome-app-helper.h>
#include <libgnomeui/gnome-stock.h>

#include "globals.h"
#include "dialogs.h"
#include "gui.h"
#include "log.h"
#include "log-ui.h"
#include "util.h"


static void log_save_cb (GtkWidget *widget, LogViewer *lv);
static void log_save_ok_clicked (GtkWidget *widget, LogViewer *lv);
static void log_hide_cb (GtkWidget *widget, LogViewer *lv);
static void log_clear_cb (GtkWidget *widget, LogViewer *lv);


static GnomeUIInfo log_file_menu[] =
{
/*	GNOMEUIINFO_MENU_OPEN_ITEM (not_implemented, NULL), */
/*  	GNOMEUIINFO_MENU_SAVE_ITEM (log_save_cb, NULL), */
	GNOMEUIINFO_MENU_SAVE_AS_ITEM (log_save_cb, NULL),
	GNOMEUIINFO_SEPARATOR,
/*	GNOMEUIINFO_MENU_PRINT_ITEM (not_implemented, NULL), */
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_CLOSE_ITEM (log_hide_cb, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo log_view_menu[] =
{
	GNOMEUIINFO_END
};

static GnomeUIInfo log_main_menu[] =
{
	GNOMEUIINFO_MENU_FILE_TREE (log_file_menu),
	GNOMEUIINFO_SUBTREE(N_("_View"), &log_view_menu),
	GNOMEUIINFO_MENU_HELP_TREE (help_menu),
	GNOMEUIINFO_END
};

static GnomeUIInfo log_toolbar[] =
{
	GNOMEUIINFO_ITEM_STOCK (N_("Save"), N_("Save this log to a file."), 
				log_save_cb, GNOME_STOCK_PIXMAP_SAVE),
	GNOMEUIINFO_ITEM_STOCK (N_("Clear"), N_("Clear this log."),
				log_clear_cb, GNOME_STOCK_PIXMAP_CLEAR),
	GNOMEUIINFO_ITEM_STOCK (N_("Close"), N_("Close the Log Viewer."),
				log_hide_cb, GNOME_STOCK_PIXMAP_CLOSE),
	GNOMEUIINFO_END

};


/* Clear out the event log list */
static void
log_clear_cb (GtkWidget *widget, LogViewer *lv)
{
	GtkCList *clist = GTK_CLIST(lv->log);

	pan_lock ();
	gtk_clist_freeze (clist);
	gtk_clist_clear (clist);
	gtk_clist_thaw (clist);
	pan_unlock ();
}

/* This callback hides the log window... */
static void
log_hide_cb (GtkWidget *widget, LogViewer *lv)
{
	gtk_widget_hide (log_viewer->window);
}

/* Bring up the Save file selection dialog */
static void
log_save_cb (GtkWidget *widget, LogViewer *lv)
{
	lv->file_entry = gtk_file_selection_new (_("Save the log to file"));

	gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (lv->file_entry));

	gtk_signal_connect_object (GTK_OBJECT (lv->file_entry), "destroy",
				   GTK_SIGNAL_FUNC (gtk_widget_destroy),
				   GTK_OBJECT (lv->file_entry));
	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (lv->file_entry)->cancel_button),
				   "clicked",
				   GTK_SIGNAL_FUNC (gtk_widget_destroy),
				   GTK_OBJECT (lv->file_entry));
	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (lv->file_entry)->ok_button),
			    "clicked",
			    GTK_SIGNAL_FUNC (log_save_ok_clicked),
			    lv);

	gtk_widget_show_all (lv->file_entry);
}

static void
log_save_ok_clicked (GtkWidget *widget, LogViewer *lv)
{
	const gchar *filename;
	FILE *log_dump;
	gint tot_rows, i;
	gchar *data[] = { NULL, NULL };

	filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION (lv->file_entry));

	gtk_clist_freeze (GTK_CLIST (lv->log));
	tot_rows = gtk_clist_append (GTK_CLIST (lv->log), data);
	gtk_clist_remove (GTK_CLIST (lv->log), tot_rows);
	gtk_clist_thaw (GTK_CLIST (lv->log));

	log_dump = fopen (filename, "w");
	if (log_dump == NULL)
	{
		g_print ("fopen() failed to save log");
		return;
	}

	for (i = 0; i < tot_rows; i++)
	{
		char* cell_text = NULL;

		gtk_clist_get_text (GTK_CLIST(lv->log), i, 1, &cell_text);
		fprintf (log_dump, "%s ", cell_text);

		gtk_clist_get_text (GTK_CLIST(lv->log), i, 0, &cell_text);
		fprintf (log_dump, "%s", cell_text);
	}

	fclose (log_dump);

	gtk_widget_destroy (GTK_WIDGET (lv->file_entry));
}

static void
log_viewer_update (void)
{
	GtkCList * clist = GTK_CLIST (log_viewer->log);
	gchar *data[2];
	LogEntry *logentry;
	GSList *list;
	GSList *l;

	/* assume the eventlog */
	list = Pan.eventlog;
	Pan.eventlog = NULL;

	for (l=list; l!=NULL; l=l->next)
	{
		logentry = (LogEntry*) l->data;

		data[0] = logentry->time;
		data[1] = logentry->event;

		pan_lock ();
		gtk_clist_prepend (clist, data);
		pan_unlock ();

		g_free (logentry->time);
		g_free (logentry->event);
		g_free (logentry);

	}

	g_slist_free (list);
}

static void
dialog_log_viewer_create (void)
{
	GtkWidget *scrolled_window;

	log_viewer->window = gnome_app_new ("Log", _("Pan - Log Viewer"));

	scrolled_window = gtk_scrolled_window_new (NULL, NULL);

	log_viewer->appbar = gnome_appbar_new (FALSE, TRUE, GNOME_PREFERENCES_USER);
	gnome_app_set_statusbar (GNOME_APP(log_viewer->window), GTK_WIDGET (log_viewer->appbar));

	gnome_app_set_contents (GNOME_APP (log_viewer->window), scrolled_window);
	gnome_app_create_menus_with_data (GNOME_APP (log_viewer->window), log_main_menu, log_viewer);
	gnome_app_create_toolbar_with_data (GNOME_APP (log_viewer->window), log_toolbar, log_viewer);
	gnome_app_install_menu_hints (GNOME_APP(log_viewer->window), log_main_menu);

	gtk_window_set_default_size (GTK_WINDOW (log_viewer->window), 450, 336);

	gtk_signal_connect_object (GTK_OBJECT (log_viewer->window), "delete_event",
				   GTK_SIGNAL_FUNC (log_hide_cb),
				   GTK_OBJECT (log_viewer->window));

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);

	gtk_container_add (GTK_CONTAINER (scrolled_window), log_viewer->log);
}

/*---[ dialog_log_viewer ]--------------------------------------------
 * pop open a log viewer, use a generic scrolling window with a 
 * text box inside to show the log of past events
 *--------------------------------------------------------------------*/
void
dialog_log_viewer (void)
{
	gchar *titles[2];
       
	titles[0] = _("Time");
	titles[1] = _("Log Entry");

	if (log_viewer && GTK_IS_WIDGET (log_viewer->window))
	{
		log_viewer_update ();
		gtk_widget_show (GTK_WIDGET (log_viewer->window));
		gdk_window_raise (log_viewer->window->window);
		return;
	}

	log_viewer = g_new0 (LogViewer, 1);

	log_viewer->log = gtk_clist_new_with_titles (2, titles);
	gtk_clist_set_column_auto_resize (GTK_CLIST(log_viewer->log), 0, TRUE);
	gtk_clist_set_column_auto_resize (GTK_CLIST(log_viewer->log), 1, TRUE);

	dialog_log_viewer_create ();

	log_viewer_update ();

	gtk_widget_show_all (log_viewer->window);
}
