/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __GROUPLIST_H__
#define __GROUPLIST_H__

#include <glib.h>

#include "group.h"
#include "pan-callback.h"
#include "server.h"

extern PanCallback * grouplist_group_selection_changed;

extern void grouplist_select_next_unread_group     (void);
extern void grouplist_select_next_group            (void);
extern void grouplist_activate_next_unread_group   (void);
extern void grouplist_activate_next_group          (void);

extern int  grouplist_get_view_mode         (void);

extern void grouplist_update_ui             (Server * server);
extern void grouplist_update_groups         (const Group ** groups, int group_qty);
extern void grouplist_process_selcted	    (int type);

extern void grouplist_subscribed_download_new          (void);
extern void grouplist_subscribed_download_new_bodies   (void);
extern void grouplist_selected_download_all            (void);
extern void grouplist_selected_download_all_bodies     (void);
extern void grouplist_selected_download_new            (void);
extern void grouplist_selected_download_new_bodies     (void);
extern void grouplist_selected_download_sample         (void);
extern void grouplist_selected_download_sample_bodies  (void);
extern void grouplist_selected_download_bodies         (void);
extern void grouplist_selected_download_dialog         (void);
extern void grouplist_selected_mark_read               (void);
extern void grouplist_selected_rename                  (void);
extern void grouplist_selected_update_count_info       (void);

extern void grouplist_selected_subscribe               (void);
extern void grouplist_selected_unsubscribe             (void);
extern void grouplist_selected_properties              (void);
extern void grouplist_selected_empty	               (void);
extern void grouplist_selected_destroy                 (void);

extern void grouplist_remove_row (const Group * group);

extern void grouplist_load		               (Server *);
extern void grouplist_select_all	               (void);
extern void grouplist_get_all	                       (void);
extern void grouplist_get_new	                       (void);
extern void grouplist_set_server                       (Server * server);
extern void grouplist_set_selected_groups              (const GPtrArray * g);

extern Server *grouplist_get_server (void);

extern GPtrArray* grouplist_get_selected_groups (void);
extern Group* grouplist_get_selected_group (void);
extern GPtrArray* grouplist_get_subscribed_groups (void);
extern gpointer grouplist_create (void);

#endif /* __GROUPLIST_H__ */
