/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include <gtk/gtk.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>

#include "articlelist.h"
#include "globals.h"
#include "grouplist.h"
#include "gui.h"
#include "gui-notebook.h"
#include "text.h"
#include "util.h"


GtkWidget * notebook = NULL;


/*---[ gui_notebook_select_all ]--------------------------------------
 * Called from gui_select_all(), this determines the page you are in
 * and performs the appropriate select_all function
 *--------------------------------------------------------------------*/
void
gui_notebook_select_all (void)
{
	switch (gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))
	{
	case 0: /* groups tab */
		grouplist_select_all ();
		break;

	case 1: /* articles tab */
		articlelist_select_all ();
		break;

	case 2: /* message tab */
		text_select_all ();
		break;

	default:
		break;
	}
}

/*---[ gui_notebook_construct ]---------------------------------------
 * Build and pack the notebook GUI layout into Pan's main vbox
 *--------------------------------------------------------------------*/
void
gui_notebook_construct (void)
{
	if (Pan.viewmode == GUI_NOTEBOOK)
		return;

	if (Pan.viewmode == GUI_PANED)
	{
		gtk_widget_ref (groups_vbox);
		gtk_container_remove (GTK_CONTAINER(groups_vbox->parent), groups_vbox);
		gtk_widget_ref (articlelist_ctree);
		gtk_container_remove (GTK_CONTAINER(articlelist_ctree->parent), articlelist_ctree);
		gtk_widget_ref (text_box);
		gtk_container_remove (GTK_CONTAINER(text_box->parent), text_box);
		gtk_container_foreach (GTK_CONTAINER(contents_vbox), (GtkCallback)gtk_widget_destroy, NULL);
	}

	notebook = gtk_notebook_new ();
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook),
				  groups_vbox,
				  gtk_label_new (_("Groups")));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook),
				  articlelist_ctree,
				  gtk_label_new (_("Articles")));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook),
				  text_box,
				  gtk_label_new (_("Message")));
	gtk_box_pack_start (GTK_BOX (contents_vbox), notebook, TRUE, TRUE, 0);

	gtk_notebook_set_tab_border (GTK_NOTEBOOK (notebook), 2);

	gui_restore_column_widths (Pan.group_clist, "group");
	gui_restore_column_widths (Pan.article_ctree, "articlelist");

	if (Pan.viewmode == GUI_PANED)
	{
		gtk_widget_unref (groups_vbox);
		gtk_widget_unref (articlelist_ctree);
		gtk_widget_unref (text_box);
	}

	Pan.viewmode = GUI_NOTEBOOK;
	gtk_widget_show_all (GTK_WIDGET(contents_vbox));
}

/**
***
**/

void gui_notebook_page_set (int page, GtkWidget * focus_item)
{
	if (Pan.viewmode == GUI_NOTEBOOK)
	{
		pan_lock();
		gtk_notebook_set_page (GTK_NOTEBOOK (notebook), page);
		gtk_widget_grab_focus (focus_item);
		pan_unlock();
	}
}
