/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <gtk/gtkclist.h>

#include "globals.h"
#include "log.h"
#include "log-ui.h"
#include "util.h"


LogViewer *log_viewer = NULL;


static LogEntry*
logentry_new (const gchar *msg)
{
	LogEntry *retval;
	const time_t cur_time = time (NULL);

	retval = g_new0 (LogEntry, 1);
	retval->time = g_strchomp (g_strdup_printf ("%s", ctime(&cur_time)));
	retval->event = g_strdup (msg);

	return retval;
}

/*---[ log_add ]------------------------------------------------------
 * @msg:
 *
 * add a message to the list of logged events
 *--------------------------------------------------------------------*/
void
log_add (const gchar *msg)
{
	LogEntry *logentry;
	gchar *data[2];

	logentry = logentry_new (msg);

	g_message (msg);

	/* update the log */
	if (log_viewer && GTK_WIDGET_VISIBLE (log_viewer->window))
	{
		data[0] = logentry->time;
		data[1] = logentry->event;

		pan_lock ();
		gtk_clist_append (GTK_CLIST (log_viewer->log), data);
		pan_unlock ();

		g_free (logentry->time);
		g_free (logentry->event);
		g_free (logentry);
	}
	else
		Pan.eventlog = g_slist_prepend (Pan.eventlog, logentry);
}

/*---[ log_add_va ]---------------------------------------------------
 * @format:
 *
 * add a message to the log file with a variable argument list
 *--------------------------------------------------------------------*/
void
log_add_va (const gchar *format, ...)
{
	va_list args;
	gchar *msg;

	g_return_if_fail (format != NULL);

	va_start (args, format);
	msg = g_strdup_vprintf (format, args);
	va_end (args);

	log_add (msg);
	g_free (msg);
}
