/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __RULE_CRITERIA_H__
#define __RULE_CRITERIA_H__

#include <time.h>
#include <sys/types.h>
#include <regex.h>

#include <glib.h>

#include "article.h"
#include "pan-object.h"

#define RULE_CRITERIA(a) ((RuleCriteria *)a)

typedef struct _RuleCriteria   RuleCriteria;

typedef enum
{
	RULE_CRITERIA_AND                 = 0,
	RULE_CRITERIA_OR                  = 1,

	RULE_CRITERIA_PHRASE              = 3,
/*	RULE_CRITERIA_IS_REPLY_TO_MINE    = 4, */
	RULE_CRITERIA_BINARY              = 5,
	RULE_CRITERIA_EXCEEDS_N_LINES     = 6,
	RULE_CRITERIA_EXCEEDS_N_GROUPS    = 7,
	RULE_CRITERIA_EXCEEDS_N_DAYS_OLD  = 8,
	RULE_CRITERIA_THREAD              = 9,
	RULE_CRITERIA_MARKED_AS           = 10,
	RULE_CRITERIA_BOZO                = 11
}
RuleCriteriaType;

typedef enum
{
	RULE_CRITERIA_PHRASE_SUBJECT,
	RULE_CRITERIA_PHRASE_AUTHOR
}
RuleCriteriaPhraseType;

typedef enum
{
	RULE_CRITERIA_THREAD_WATCHED,
	RULE_CRITERIA_THREAD_IGNORED
}
RuleCriteriaThreadType;

typedef enum
{
	RULE_CRITERIA_MARKED_READ,
	RULE_CRITERIA_MARKED_UNREAD
}
RuleCriteriaMarkedType;

typedef enum
{
	RULE_CRITERIA_BINARY_COMPLETE,
	RULE_CRITERIA_BINARY_INCOMPLETE,
	RULE_CRITERIA_BINARY_NONBINARY
}
RuleCriteriaBinaryType;

struct _RuleCriteria
{
	/* parent class */
	PanObject parent;

	RuleCriteriaType type;
	GPtrArray * children;
	gboolean not;

	/* phrase */
	RuleCriteriaPhraseType phrase_type;
	gboolean phrase_does;
	gboolean phrase_is_regex;
	gchar * phrase;
	regex_t phrase_regex;

	/* rule_criteria_exceeds_* */
	int exceeds_n;

	/* thread */
	RuleCriteriaThreadType thread_type;

	/* article marked as */
	RuleCriteriaMarkedType marked_type;

	/* binary type */
	RuleCriteriaBinaryType binary_type;
};

/**
***  PROTECTED
**/

void         rule_criteria_constructor          (RuleCriteria * r);

void         rule_criteria_destructor           (PanObject * o);

/**
***  PUBLIC - Life Cycle
**/

RuleCriteria*  rule_criteria_new                  (void);

RuleCriteria*  rule_criteria_dup                  (const RuleCriteria * r);

RuleCriteria*  string_to_rule_criteria_single     (const gchar * line,
                                                   gint * setme_depth);

RuleCriteria*  string_to_rule_criteria_recursive  (const gchar * line);

gchar*         rule_criteria_tostring_single      (const RuleCriteria * r,
                                                   int depth);

void           rule_criteria_tostring_recursive   (const RuleCriteria * r,
                                                   GString * appendme,
                                                   gint depth);

/**
***  PUBLIC
**/

void           rule_criteria_remove_failures      (const RuleCriteria *,
                                                   GPtrArray * articles);

gboolean       rule_criteria_test_article         (const RuleCriteria * r,
                                                   const Article * a);

void           rule_criteria_set_phrase           (RuleCriteria * r,
                                                   const gchar * phrase,
                                                   gboolean contains,
                                                   gboolean is_regex);

void           rule_criteria_add_child            (RuleCriteria * parent,
                                                   RuleCriteria * child);

#endif /* __RULE_CRITERIA_H__ */
