/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*********************
**********************  Includes
*********************/

#include <config.h>

#include <stdlib.h>
#include <string.h>

#include <glib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>

#include "article.h"
#include "debug.h"
#include "nntp.h"
#include "queue.h"
#include "task-bodies.h"
#include "util.h"

/*********************
**********************  Defines / Enumerated types
*********************/

/*********************
**********************  Macros
*********************/

/*********************
**********************  Structures / Typedefs
*********************/

/*********************
**********************  Private Function Prototypes
*********************/

static int task_bodies_run (Task* item);

static gchar* task_bodies_describe (const StatusItem* item);

/*********************
**********************  Variables
*********************/

/***********
************  Extern
***********/

/***********
************  Public
***********/

/***********
************  Private
***********/

/*********************
**********************  BEGINNING OF SOURCE
*********************/

static void
task_bodies_destructor (PanObject *o)
{
	TaskBodies * task = TASK_BODIES(o);

	/* destroy TaskBodies parts */
	group_unref_articles (task->group, NULL);
	g_ptr_array_free (task->articles, TRUE);
	task->articles = NULL;
	task->working_index = 0;

	/* destroy parent class */
	task_destructor (o);
}

/************
*************  PUBLIC ROUTINES
************/

PanObject*
task_bodies_new (Group       * group,
                 GPtrArray   * articles)
{
	TaskBodies* bodies = NULL;

	/* sanity checks */
	g_return_val_if_fail (group!=NULL, NULL);
	g_return_val_if_fail (articles!=NULL, NULL);
	g_return_val_if_fail (articles->len!=0, NULL);

	group_ref_articles (group, NULL);

	/* create the object */
       	bodies = g_new0 (TaskBodies, 1);
        debug1 (DEBUG_PAN_OBJECT, "task_bodies_new: %p", bodies);

	/* initialize the parent class */
	task_constructor (TASK(bodies),
		task_bodies_destructor,
		task_bodies_describe,
		task_bodies_run,
		group->server, TRUE, TRUE);

	/* initialize the task-bodies */
	bodies->group = group;
	bodies->articles = articles;
	bodies->working_index = 0;

	return PAN_OBJECT(bodies);
}

/*****
******
*****/

static gchar*
task_bodies_describe (const StatusItem* si)
{
	TaskBodies *item = TASK_BODIES(si);

	return g_strdup_printf (_("Downloading %d articles from group %s"),
		item->articles->len,
		item->group->name );
}

/*****
******
*****/

static int
task_bodies_run (Task* task)
{
	status_item_emit_init_steps (STATUS_ITEM(task),
	                             (int)TASK_BODIES(task)->articles->len);

	return nntp_download_bodies (STATUS_ITEM(task),
	                             TASK_BODIES(task)->group,
                                     task->sock,
                                     &task->hint_abort,
                                     TASK_BODIES(task)->articles,
                                     &TASK_BODIES(task)->working_index);
}
