/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*********************
**********************  Includes
*********************/

#include <config.h>

#include "debug.h"
#include "task-func-ptr.h"

/*********************
**********************  Defines / Enumerated types
*********************/

/*********************
**********************  Macros
*********************/

/*********************
**********************  Structures / Typedefs
*********************/

/*********************
**********************  Private Function Prototypes
*********************/

/*********************
**********************  Variables
*********************/

/***********
************  Extern
***********/

/***********
************  Public
***********/

/***********
************  Private
***********/

/*********************
**********************  BEGINNING OF SOURCE
*********************/

/************
*************  PUBLIC ROUTINES
************/

/*****
******
*****/

static void
task_func_ptr_destructor (PanObject * obj)
{
	TaskFuncPtr * task = TASK_FUNC_PTR(obj);

        debug1 (DEBUG_PAN_OBJECT, "task_func_ptr destructor: %p", obj);
	if (task->user_dtor != NULL)
		(*task->user_dtor)(task);

	task_destructor (obj);
}

static int
task_func_ptr_run (Task * task)
{
	TaskFuncPtr * tfp = TASK_FUNC_PTR(task);
	return (*tfp->run)(tfp, tfp->user_data);
}


PanObject* task_func_ptr_new (Server * server,
                              StatusItemDescribeFunc describe,
                              TaskFuncPtrRunFunc run,
                              gpointer user_data,
                              GDestroyNotify dtor)
{
	TaskFuncPtr * item;

	g_return_val_if_fail (run!=NULL, NULL);

       	item = g_new0 (TaskFuncPtr, 1);
        debug1 (DEBUG_PAN_OBJECT, "task_func_ptr_new: %p", item);
	task_constructor (TASK(item),
			  task_func_ptr_destructor,
			  describe,
			  task_func_ptr_run,
			  server, FALSE, TRUE);


	/* construct this class... */
	item->run = run;
	item->user_data = user_data;
	item->user_dtor = dtor;

	return PAN_OBJECT(item);
}

/*****
******
*****/
