/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ARTICLE_THREAD_H__
#define __ARTICLE_THREAD_H__

#include <glib.h>
#include "article.h"
#include "status-item.h"

/* this calls queue_item_emit_next_step list_len times. */

typedef enum
{
	ARTICLE_SORT_SUBJECT = 1,
	ARTICLE_SORT_DATE = 2,
	ARTICLE_SORT_AUTHOR = 3,
	ARTICLE_SORT_LINES = 4,
	ARTICLE_SORT_UNREAD_CHILDREN = 5,
	ARTICLE_SORT_MSG_ID = 6,
	ARTICLE_SORT_TYPES_QTY = 6,
}
ArticleSortType;

extern void sort_articles (
        Article** buf,
        size_t article_qty,
        int sort_type,
        gboolean ascending );


void thread_articles (GPtrArray     * articles,
                      StatusItem    * status);

void check_multipart_articles (GPtrArray * articles);

#endif /* __ARTICLE_THREAD_H__ */
