/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __GUI_H__
#define __GUI_H__

#include <gtk/gtkwidget.h>
#include <libgnomeui/gnome-app.h>
#include <libgnomeui/gnome-app-helper.h>

#include "article.h"
#include "group.h"
#include "status-item.h"

extern GtkWidget * groups_vbox;
extern GtkWidget * articlelist_ctree;
extern GtkWidget * text_box;
extern GtkWidget * contents_vbox;

extern GnomeUIInfo help_menu[];

enum {
	GUI_PANED = 1,
	GUI_NOTEBOOK
};

enum {
	GROUPS_PAGE = 0,
	ARTICLELIST_PAGE,
	MESSAGE_PAGE
};

void gui_about (void);

void gui_shutdown (void);

void widget_set_font (GtkWidget* w, const char* font_name);

void dialog_draw_centered (GtkWidget *dialog, GtkWidget *window);

void gui_set_layout(int);

void gui_construct (const gchar *geometry);

void gui_page_set (int page, GtkWidget *focus_item);

void gui_set_title (const Group*);

void gui_restore_column_widths    (GtkWidget * clist, const gchar * key);

void gui_save_column_widths       (GtkWidget * clist, const gchar * key);

void gui_restore_window_size      (GtkWidget * window, const gchar * key);

void gui_save_window_size         (GtkWidget * window, const gchar * key);

void gui_select_all (void);

GtkWidget* server_menu_create (void);


void gui_set_connecting_flag (gboolean is_connecting);
void gui_set_connection_size (int size);
void gui_inc_connection_size (int inc);

void gui_set_queue_size (int running, int total);

extern GnomeUIInfo group_menu [];
extern GnomeUIInfo folder_menu [];

extern GdkColormap * cmap;

#endif /* __GUI_H__ */
