/*
 * Pan - A Newsreader for X
 * Copyright (C) 2000, 2001  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef TASK_FUNCPTR_H
#define TASK_FUNCPTR_H

#include <glib.h>
#include "task.h"
#include "group.h"

/**
***  TASK FUNCPTR DECLARATION
**/

typedef struct _TaskFuncPtr TaskFuncPtr;

typedef int (*TaskFuncPtrRunFunc)(struct _TaskFuncPtr*, gpointer user_data);

#define TASK_FUNC_PTR(obj) ((TaskFuncPtr*)obj)

/**
 * A TaskFuncPtr is a simple way of writing lightweight tasks.
 * The basic idea is that you pass in a function pointer in its
 * constructor, and then when task_run() is invoked, that function
 * will be called.
 */
struct _TaskFuncPtr
{
	/* Parent */
	Task parent;

	/* private */
	TaskFuncPtrRunFunc run;
	GDestroyNotify user_dtor;
	gpointer user_data;
};


/**
***   PUBLIC
**/

PanObject* task_func_ptr_new (Server                    * server,
                              StatusItemDescribeFunc      describe,
                              TaskFuncPtrRunFunc          run,
                              gpointer                    user_data,
                              GDestroyNotify              user_dtor);
#endif
