/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __TEXT_H__
#define __TEXT_H__

#include <gdk/gdk.h>
#include "message-window.h"
#include "pan-callback.h"

/**
***  CURRENT ARTICLE
**/

/**
 * called whenever the current article changes.
 * @param call_object the old article
 * @param call_arg the new article
 */
extern PanCallback * current_article_changed;

extern Article * get_current_article (void);

extern void set_current_article (Article*);

/**
***  Wrapping
**/

void          text_set_wrap                                  (gboolean);
gboolean      text_get_wrap                                  (void);
PanCallback*  text_get_fill_body_changed_callback            (void);

/**
***  Show all Headers
**/

void          text_set_show_all_headers                      (gboolean);
gboolean      text_get_show_all_headers                      (void);
PanCallback*  text_get_show_all_headers_changed_callback     (void);

/**
***  Mute Quoted Text
**/

void          text_set_mute_quoted                           (gboolean);
gboolean      text_get_mute_quoted                           (void);
PanCallback*  text_get_mute_quoted_changed_callback          (void);

/**
***  Rot 13
**/

void          text_set_rot13                                 (gboolean);

/**
***  Colors
**/

extern GdkColor text_fg_color;
extern GdkColor text_bg_color;
extern GdkColor text_quoted_color;


/**
***
**/

void         text_read_more               (void);

GtkWidget*   text_create                  (void);

void         text_select_all              (void);

void         text_refresh                 (void);


/**
 * This will display the message, if it exists in the acache.
 * If it's not in the acache, this method does nothing.
 * @param article the article to show
 */
void      text_update                     (Article             * article);

/**
 * This will add a task that tries to load the article's body 
 * from a local cache or from the news server.
 * If it's able to load the body, it will show it.
 */
void      text_set_from_article           (Article             * article,
                                           MessageWindowType     type,
                                           gboolean              needs_window);

void      text_set_raw                    (const gchar         * text);

gchar*    text_get_message_to_reply_to    (void);

void      text_set_font                   (const gchar         * font_name);

#endif /* __TEXT_H__ */
