// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 4 -*-

/*
 *  PaperBox - document-tile-view.hh
 *
 *  Copyright (C) 2007 Marko Anastasov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __PAPER_BOX_DOCUMENT_TILE_VIEW_HH__
#define __PAPER_BOX_DOCUMENT_TILE_VIEW_HH__

#include <gtkmm-utils/tile-view.h>
#include "document-tile.hh"

namespace paperbox {

    class DocumentTileView : public Gtk::Util::TileView
    {
    public:
        typedef sigc::signal<void, const Glib::ustring&> SignalTagClicked;

        explicit DocumentTileView(bool use_page_view = true);
        ~DocumentTileView();

        // TileView overrides
        virtual void add_tile(Gtk::Util::Tile& tile);
        virtual void add_tile(Gtk::Util::Tile* tile);

        // Signal propagated from individual DocumentTileView widgets
        SignalTagClicked& signal_tag_clicked() { return signal_tag_clicked_; }

    protected:
        void connect_to_extra_signals(DocumentTile* tile);

        // Handlers for additional signals that DocumentTile provides.
        virtual void on_tag_selected(const Glib::ustring& tag);

        SignalTagClicked signal_tag_clicked_;
    };

} 

#endif // __PAPER_BOX_DOCUMENT_TILE_VIEW_HH__
