// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 4 -*-

/*
 *  PaperBox - main-window.hh
 *
 *  Copyright (C) 2007 Marko Anastasov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __PAPER_BOX_MAIN_WINDOW__
#define __PAPER_BOX_MAIN_WINDOW__

#include <boost/shared_ptr.hpp>
#include <gtkmm/box.h>
#include <gtkmm/paned.h>
#include <gtkmm/window.h>
#include <gtk/gtkwindow.h>
#include <libglademm.h>
#include <gtkmm-utils/tile.h>
#include "category-view.hh"
#include "document-tile-view.hh"
#include "tag-cloud-model.hh"
#include "tag-cloud.hh"
#include "tile-set.hh"
#include "thumbnailer.hh"

namespace paperbox {

    class Browser;
    class CategoryModel;
    class Config;
    class Document;

    // These consts are used by configuration code.
    const int DEFAULT_WIDTH = 800;
    const int DEFAULT_HEIGHT = 690;
    const int DEFAULT_CATEGORY_PANED_POS = 280;

    class MainWindow : public Gtk::Window
    {
    public:
        explicit MainWindow(GtkWindow* cobject,
                            const Glib::RefPtr<Gnome::Glade::Xml>& glade);
        virtual ~MainWindow();

        static MainWindow* create();

    protected:
        void init_gui(const boost::shared_ptr<Config>& cfg);
        void get_widgets_from_ui_file();
        void setup_tiles();
        void setup_categories();
        void reload_category_view();
        void connect_signals();

        void render_new_tile_set(
            const std::vector<boost::shared_ptr<Document> >& docs);

        void render_documents(
            const std::vector<boost::shared_ptr<Document> > docs);

        /*** Signal handlers ***/
        void on_new_document(const boost::shared_ptr<Document>& doc);

        void on_document_tile_selected(/*Document*/Gtk::Util::Tile& t);

        // Handler for DocumentTileView's and TagCloud's signals
        void on_tag_clicked(const Glib::ustring& tag);

        void on_edit_category();

        bool on_category_selected(const Glib::RefPtr<Gtk::TreeModel>& ,
                                  const Gtk::TreeModel::Path& path,
                                  bool path_currently_selected);

        /*** Members ***/
        Browser* browser_;

        Glib::RefPtr<Gnome::Glade::Xml> glade_;

        /*@* Child widgets *@*/

        // ~left side~
        Gtk::HPaned*      hpane_;
        Gtk::VBox*        left_top_vbox_;
        DocumentTileView* tile_view_;

        boost::shared_ptr<TileSet> tiles_;

        // ~right side~
        Gtk::VBox*   right_top_vbox_;
        Gtk::VPaned* right_vpane_;

        // categories

        Gtk::VBox* category_vbox_;
        boost::shared_ptr<CategoryView> category_view_;
        Glib::ustring selected_cat_name_;

        Gtk::HBox*  category_buttons_hbox_;
        Gtk::Button button_edit_category_;

        boost::shared_ptr<CategoryModel> category_model_;

        // tag cloud
        Gtk::VBox*  tag_cloud_vbox_;
        Gtk::Label  label_tags_;

        boost::shared_ptr<TagCloudModel> model_;
        TagCloud    tag_cloud_;
        Gtk::VBox   tag_box_;

        Thumbnailer thumbnailer_;

    private:
        // Non-copyable:
        MainWindow(const MainWindow& );
        MainWindow& operator=(const MainWindow& );
    };

} // namespace paperbox

#endif // __PAPER_BOX_MAIN_WINDOW__
