%define ver 0.12
%define name planner

Summary: 	A graphical project management tool.
Name:           %name
Version:        %ver
Release:	imendio.1
License: 	GPL
Group: 		Applications/Productivity
Url:		http://planner.imendio.org/
Source: 	%{name}-%{ver}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{ver}-root
Obsoletes:	mrproject libmrproject

Requires:	gtk2 >= 2.0.3
Requires:       libgnomeui >= 2.0.1
Requires:	popt >= 1.5
Requires:	libglade2 >= 2.0.0
Requires:       gnome-vfs2 >= 2.0.2
Requires:       libgnomeprintui22 >= 2.2.0
Requires:       libxslt >= 1.0
PreReq:         scrollkeeper >= 0.3.10

BuildRequires:	gtk2-devel >= 2.0.3
BuildRequires:	libgnomeui-devel >= 2.0.1
BuildRequires:	libglade2-devel >= 2.0.0
BuildRequires:  gnome-vfs2-devel >= 2.0.2
BuildRequires:  libgnomeprintui22-devel >= 2.2.0
BuildRequires:  libxml-devel >= 2.5.4
BuildRequires:  libxslt-devel >= 1.0.27
BuildRequires:	intltool autoconf automake17

BuildRequires:	libgda-devel

%description
Planner is a visual project management application which allows users to
manage several aspects of a project, including schedule tracking using
Gantt charts.

You should install Planner if you wish to manage schedules, allocate
resources, and track the progress of your projects.

%prep
%setup -q

%build

intltoolize --force
libtoolize --force
aclocal-1.7
automake-1.7
autoconf
%configure --enable-database --enable-python --enable-gtk-doc --disable-dotnet

make

%install
rm -rf "%{buildroot}"

%makeinstall

/bin/rm -rf %{buildroot}/var/scrollkeeper
/bin/rm %{buildroot}/%{_libdir}/*.la
/bin/rm %{buildroot}/%{_libdir}/planner/file-modules/*.la
/bin/rm %{buildroot}/%{_libdir}/planner/storage-modules/*.la
/bin/rm %{buildroot}/%{_libdir}/planner/plugins/*.la
/bin/rm %{buildroot}/%{_libdir}/planner/views/*.la
/bin/rm %{buildroot}/%{_libdir}/python*/site-packages/gtk-2.0/*.la

/bin/rm %{buildroot}/%{_datadir}/mime/XMLnamespaces
/bin/rm %{buildroot}/%{_datadir}/mime/globs
/bin/rm %{buildroot}/%{_datadir}/mime/magic
/bin/rm %{buildroot}/%{_datadir}/mime/application/*

%find_lang %name

%clean
rm -rf "%{buildroot}"

%post
scrollkeeper-update
if (update-mime-database -v &> /dev/null); then
  update-mime-database "%{_datadir}/mime" > /dev/null
fi

%postun
scrollkeeper-update
if (update-mime-database -v &> /dev/null); then
  update-mime-database "%{_datadir}/mime" > /dev/null
fi

%files
%defattr(-,root,root)
%doc ChangeLog NEWS README COPYING
%{_bindir}/planner
%{_libdir}/planner
%{_libdir}/libplanner-1*
%{_libdir}/pkgconfig/*
%{_libdir}/python*/site-packages/gtk-2.0/*
%{_datadir}/planner
%{_datadir}/application-registry/*
%{_datadir}/mime-info/*
%{_datadir}/mime/packages/*
%{_datadir}/pixmaps/*
%{_datadir}/applications/*
%{_datadir}/gtk-doc/html/libplanner
%{_datadir}/gnome/help/planner/*
%{_datadir}/omf/planner/planner-C.omf
%{_datadir}/locale/*/LC_MESSAGES/*
%{_datadir}/doc/planner/sample-*.planner
%{_includedir}/planner-1.0

%exclude %{_libdir}/planner/file-modules/libmrp-xsl*
%exclude %{_libdir}/planner/storage-modules/libstorage-sql*
%exclude %{_libdir}/planner/plugins/libsql-plugin*
%exclude %{_datadir}/planner/glade/sql.glade
%exclude %{_datadir}/planner/ui/sql-plugin.ui
%exclude %{_datadir}/planner/sql/*
%exclude %{_datadir}/doc/planner/README.sql

# Database (GDA) package
%package database
Summary:	Planner database support
Group:          Applications/Productivity
Requires:       %name = %{PACKAGE_VERSION}
Requires:       libgda
BuildRequires:  libgda-devel

%description database
Database support for Planner, this plugin can be used to store projects in a PostgreSQL database.

%files database
%defattr(-,root,root)
%{_libdir}/planner/file-modules/libmrp-xsl*
%{_libdir}/planner/storage-modules/libstorage-sql*
%{_libdir}/planner/plugins/libsql-plugin*
%{_datadir}/planner/glade/sql.glade
%{_datadir}/planner/ui/sql-plugin.ui


%changelog
* Thu Jun 24 2004 Richard Hult <richard@imendio.com>
- Fix up to actually work.

* Mon Dec 1 2003 Richard Hult <richard@imendio.com>
- Start over with a new spec file, needs a lot more work.
