/*
 This file is part of pybliographer
 
 Copyright (C) 1998 Frederic GOBRY
 Email : gobry@idiap.ch
 	   
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version.
   
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
 $Id: bibtex.h,v 1.7 1998/10/28 13:29:12 gobry Exp $
*/

#ifndef __bibtex_h__
#define __bibtex_h__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdlib.h>

#undef USE_DMALLOC  
#include <glib.h>
#include <stdarg.h>
#include <stdio.h>


  typedef struct {
    gchar * type;
    gchar * name;
    int length;
    int offset;

    gchar * body;

    GHashTable * table;
  } 
  bibtex_entry;

  typedef struct {
    FILE * file;

    int line;
    int offset;

    GHashTable * table;
    gpointer buffer;

    int debug;
    gboolean eof, error;
  }
  bibtex_file;

  /* -------------------------------------------------- 
     High level interface
     -------------------------------------------------- */

  extern bibtex_file * bibtex_open (gchar * file);
  extern void bibtex_close (bibtex_file *);

  extern bibtex_entry * bibtex_next_entry (bibtex_file * file);
  extern void bibtex_first_entry (bibtex_file * file);
  extern void bibtex_offset_entry (bibtex_file * file, gint);


  /* Start a new analyser on a file */
  extern void bibtex_analyzer_initialize (bibtex_file * file);
  /* Parse next entry */
  extern bibtex_entry * parse_bibtex (bibtex_file * file);
  /* Deallocate analyzer */
  extern void bibtex_analyzer_finish (bibtex_file * file);

  extern void bibtex_free_entry (bibtex_entry * entry);
  
  extern void tmp_string (char *);
  extern void tmp_string_free (void);


  extern char * merge_strings (char *, char *);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* bibtex.h */
