# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: pybhelp.py,v 1.4 1998/10/28 13:29:07 gobry Exp $

import string
import sys

Topics = {}

# --------------------------------------------------
def register (topic, help):
	"Register a new help topic"
	
	Topics [topic] = help


	
# --------------------------------------------------
def help (argument):
	"The help function, as called by the main program"

	if argument == "":
		print """Type help <topic> for specific info.

Topics:"""
		tcount = 0
		topics = Topics.keys ()
		topics.sort ()
		
		for topics in topics:
			sys.stdout.write (' ' + string.ljust (topics, 20))
			tcount = tcount + 1
			if tcount > 3:
				tcount = 0
				print
		if tcount > 0:
			print
				
	else:
		argument = argument [:-1]
		if Topics.has_key (argument):
			print '-' * (len (argument) + 3)
			print " %s" % argument
			print '-' * (len (argument) + 3)
			print Topics [argument]
			print
		else:
			print "error: topic `%s' not documented" % argument
		
