# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: Entry.py,v 1.3 1999/07/30 12:34:13 gobry Exp $

from Pyblio.Base import *
import string
from gnome.ui import *
from gtk import *
from  Pyblio.GnomeUI import Config
from Pyblio import Fields

class Entry (GtkScrolledWindow):
    """ Simple entry displayer """
    
    def __init__ (self, entry):
        GtkScrolledWindow.__init__ (self)
        self.set_policy (POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        self.set_usize (500,300)
        
        self.entry = entry
        box = GtkVBox (FALSE, 5)
        self.add_with_viewport (box)
        box.show ()
        
        tmp = GtkLabel ("Entry (" + entry.name +")")
        box.pack_start (tmp, FALSE, FALSE)
        tmp.show ()

        ent = entry.type

        # Notebook holding Mandatory/Optional fields
        tmp = GtkNotebook ()
        
        self.mandatory = GtkTable (len (ent.mandatory), 2, FALSE)
        self.mandatory.set_col_spacings (5)
        self.mandatory.set_border_width (5)
        tmp.append_page (self.mandatory, GtkLabel ("Mandatory"))
        self.mandatory.show ()

        self.optional  = GtkTable (len (ent.optional), 2, FALSE)
        self.optional.set_col_spacings (5)
        self.optional.set_border_width (5)
        tmp.append_page (self.optional, GtkLabel ("Optional"))
        self.optional.show ()

        self.extra  = GtkTable (len (ent.optional), 2, FALSE)
        self.extra.set_col_spacings (5)
        self.extra.set_border_width (5)
        tmp.append_page (self.extra, GtkLabel ("Extra"))
        self.extra.show ()

        box.pack_start (tmp)
        tmp.show ()
        
        def add_field (self, table, name, text, row):
            tmp = GtkLabel (name)
            table.attach (tmp, 0, 1, row, row + 1, 0)
            tmp.show ()
            
            type = Config.fieldwidget (name)
            
            if type == Config.WidgetText:
                tmp = GtkText ()
                tmp.set_word_wrap (1)
                tmp.set_editable (TRUE)

                if text:
                    tmp.insert_defaults (str (text))

            elif type == Config.WidgetEntry:
                tmp = GtkEntry ()
                tmp.set_editable (TRUE)

                if text:
                    tmp.set_text (str (text))

            elif type == Config.WidgetAuthor:
                tmp = GtkText ()
                tmp.set_editable (TRUE)
                tmp.set_usize (100,50)

                if not text: return
                
                def str_auth (auth):
                    if auth.first:
                        return auth.last + ', ' + auth.first
                    else:
                        return auth.last

                
                tmp.insert_defaults (join (map (str_auth, text), "\n"))

            else:
                tmp = GtkEntry ()
                tmp.set_editable (TRUE)

                if text:
                    tmp.set_text (text)
            
            table.attach (tmp, 1, 2, row, row + 1)
            tmp.show ()

        dico = entry.keys ()

        i = 0
        for f in ent.mandatory:
            uc = f.name
            lc = string.lower (uc)
            if entry.has_key (lc):
                text = entry [lc]
                dico.remove (lc)
            else:
                text = None
                
            add_field (self, self.mandatory, uc, text, i)
            i = i + 1

        i = 0
        for f in ent.optional:
            uc = f.name
            lc = string.lower (uc)
            if entry.has_key (lc):
                text = entry [lc]
                dico.remove (lc)
            else:
                text = None
                
            add_field (self, self.optional, uc, text, i)
            i = i + 1

        # self.optional.resize (len (ent.optional) + len (dico.keys ()), 2)
        
        for lc in dico:
            add_field (self, self.extra, lc, entry [lc], i)
            i = i + 1
