%{

/*
 This file is part of pybliographer
 
 Copyright (C) 1998-1999 Frederic GOBRY
 Email : gobry@idiap.ch
 	   
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version.
   
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
 $Id: biblex.l,v 1.16 1999/07/19 08:57:51 gobry Exp $
*/

#include "parsername.h"
#include "bibtex.h"
#include "bibparse.h"

static BibtexFile * current_file;

gboolean bibtex_parser_is_content;

extern void bibtex_next_line (void);

#define YY_USER_ACTION  current_file->offset += yyleng;

/* Start the parser on the specified file */
void bibtex_parser_initialize (BibtexFile * file) {
    g_return_if_fail (file != NULL);
    
    /* Destroy old buffer */
    if (file->buffer) {
	yy_delete_buffer ((YY_BUFFER_STATE) file->buffer);
    }
    
    file->buffer = (gpointer) yy_create_buffer (file->file, 1024);
}

/* Continue parsing on the next entry */
void bibtex_parser_continue (BibtexFile * file) { 
    g_return_if_fail (file != NULL);
    
    current_file = file;
    
    yy_switch_to_buffer ((YY_BUFFER_STATE) file->buffer);
    BEGIN (INITIAL); 
}

/* Parsing is over */
void bibtex_parser_finish (BibtexFile * file) {
    g_return_if_fail (file != NULL);
    
    if (file->buffer) {
	yy_delete_buffer ((YY_BUFFER_STATE) file->buffer);
	file->buffer = NULL;
    }
}
 
%}

DIGIT    [0-9]+
NAME     [^ \\\t{}\"@(),=%#\n~]+
BODY 	 [^{}\\\" \n\t~]+

%option noyywrap
%x comment entry

%%
		if (YY_START == INITIAL) { BEGIN(comment); }

<comment>^[ \t]*@     	BEGIN(entry); return ('@'); /* Match begin of entry */

<comment>\n		bibtex_next_line (); /* Increment line number */
			
<comment>.


<comment,entry><<EOF>>  {  
    /* Indicate EOF */
    return (end_of_file); 
}

<entry>\\([a-zA-Z]+|[^a-zA-Z]) {
    /* Gestion du caractere \ */
    gchar * tmp;

    yylval.text = g_strdup (yytext); 
    bibtex_tmp_string (yylval.text);

    return (L_COMMAND); 
}

<entry>{BODY} {
    if (bibtex_parser_is_content) {
	/* Word in the text */
	yylval.text = bibtex_tmp_string (g_strdup (yytext));

	return L_BODY;
    }

    /* Don't parse it if we are not inside a text field */
    current_file->offset -= yyleng;
    REJECT;
}


<entry>[ \t\n~]+ 	{
    /* Spaces handling */
    char * tmp = yytext;
    
    while (* tmp) {
	if (* tmp == '\n') bibtex_next_line ();
	tmp ++;
    }

    if (bibtex_parser_is_content) {
	/* Is it an unbreakable space ? */
	if (strcmp (yytext, "~") == 0) {
	    return L_UBSPACE;
	}
	return L_SPACE;
    }
}


<entry>{DIGIT}	 { 
    /* Lecture d'un nombre */

    yylval.text = g_strdup (yytext); 
    bibtex_tmp_string (yylval.text); 

    return (L_DIGIT); 
}


<entry>{NAME} { 
    /* Lecture d'un nom simple */

    yylval.text = g_strdup (yytext); 
    bibtex_tmp_string (yylval.text); 

    return (L_NAME); 
}

<entry>. 	{
    return yytext [0];
}
%%

