# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: html.py,v 1.2 1999/07/30 12:34:23 gobry Exp $


""" This module is a formatter for HTML output """


import Pyblio.Formatter
import string, recode


htmlcode = recode.request ("latin1..html")

def qs (s):
    return recode.recode (htmlcode, s)


class HTML (Pyblio.Formatter.Formatter):
    
    def write (self, text, style = None):
        if   style == 'bold':
            self.out.write ('<b>%s</b>' % qs (text))
        elif style == 'italic' or style == 'slanted':
            self.out.write ('<i>%s</i>' % qs (text))
        else:
            self.out.write (qs (text))

    def start_group (self, id):
        self.out.write ('<dl>\n')
        return
    
    def end_group (self):
        self.out.write ('</dl>\n')
        return

    def start (self, key):
        return

    
Pyblio.Formatter.register ('HTML', HTML)

