# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: docbook.py,v 1.1 1999/09/02 12:57:37 gobry Exp $


# SGML DocBook Module

import sys, string
from Pyblio.recode import *

from Pyblio import Base, Open, Config

Mapping = Config.get ("docbook/mapping").data

if Mapping is None:
    Mapping = {'abstract' : 'Abstract',
               'title'    : 'Title',
               'pages'    : 'PageNums',
               'volume'   : 'VolumeNum',
               'year'     : 'PubDate',
               'isbn'     : 'ISBN',
               'issn'     : 'ISSN',
               'dates'    : 'Date',
               }
    
qs = recode ("latin1..html")

def printer (entry, output):
    """Compose the next entry"""
    
    output.write ("<BiblioEntry>\n")
    
    # First, the authors
    if entry.has_key ('author'):
        output.write (" <AuthorGroup>\n")
        
        for author in entry ['author']:
            output.write ("  <Author>\n")
            if author.honorific:
                output.write ("   <Honorific> " + qs (author.honorific) +
                              "  </Honorific>\n")
            if author.first:
                output.write ("   <Firstname> " + qs (author.first) +
                              "  </Firstname>\n")
            if author.last:
                output.write ("   <Surname> " + qs (author.last) +
                              "  </Surname>\n")
            if author.lineage:
                output.write ("   <Lineage> " + qs (author.lineage) +
                              "  </Lineage>\n")
            output.write ("  </Author>\n")
                
        output.write (" </AuthorGroup>\n")

    if entry.has_key ('publisher'):
        output.write (" <Publisher><PublisherName> %s </PublisherName></Publisher>\n" %
                      str (entry ['publisher']))

    # Then, the more regular entries
    for field in entry.keys ():
        if Mapping.has_key (field):
            sf = Mapping[field]
            output.write (' <'  + sf + '> ' +
                          qs (str (entry [field])) +
                          ' </' + sf + ">\n")

    # Close the field
    output.write ("</BiblioEntry>\n")
    return

def database_writer (database, output):
    output.write ("<!-- Generated by Pybliographer -->\n\n")
    output.write ("<Bibliography>\n")

    for key in database.keys ():
        entry = database [key]
        printer (entry, output)

    output.write ("</Bibliography>\n")
    return

Open.register ('DocBook',
               {'write' : database_writer})
