// $Id: properties.h,v 1.7 2000/10/31 17:18:22 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999-2000 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef RADIO_properties
#define RADIO_properties

#include "tuner.h"
#include "driver.h"
#include "speedtuner.h"
#include "volume.h"

#include <gnome--.h>
#include <vector>

class Properties: public Gnome::PropertyBox
{
    // Page 1: General settings
    // The radio device
    Gtk::Entry fldDev;
    Gtk::SpinButton fldStep;
    // User interface
    Gtk::SpinButton fldProgbutton_col, fldProgbutton_row;
    // Persistency
    Gtk::CheckButton chkMuteExit;
    Gtk::CheckButton chkSavePos;
    int pageGeneral;

    // Page 2: Stations
    Gtk::Entry** prog_val;
    Gtk::Entry** prog_name;
    int pageStations;

public:
    Properties();
    void set_stations(const vector<pair<float, string> >
		      stations);
    SigC::Signal1<void, const string&> device_change;
    SigC::Signal1<void, const vector<pair<float, string> >& > station_change;
private:
    vector<pair<float, string> > station_data;
    void do_apply(int page);
    void update();
};

#endif
